<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Hash;
use Spatie\Permission\Traits\HasPermissions;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Redirect;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */



    public function __construct()
    {

        $this->middleware('guest')->except('logout');
    }

    public function showLoginForm()
    {
        return view('auth.login');
    }


    //Surcharge
    public function login_api(Request $request)
    {
        if(!$request->password) 
        Route::post('search', ['middleware' => 'guest', function () {
            return view('auth.login_api');
        }]);

        //return view('auth.login_api');
    }


    //Surcharge
    public function login(Request $request)
    {

        if(!$request->password) $this->validateLogin($request);
dd('e');
        $email="gendarmerie@mail.wf";
        $password=$request->password;

        $request->merge(['email' => $email]); //Fore id

        //$user = new User;
        //$user = $user=User::where('email','=',$email)->first();
        //$user->name = "ADMINISTRATEUR";
        //$user->email      = strtolower($request->email);
        //$user->password   = Hash::make('admin');
        //$user->save();

        if ($this->attemptLogin($request)) {
            $email=$request->email;
            $user=User::where('email','=',$email)->first();           

            if(!$user->actif) { //Si desactivé
                Auth::logout();
                return $this->sendFailedLoginResponse($request);
            }

            $id = $user->id;
            Session::put('id', $user->id);
            Session::put('nom', $user->name);
            Session::put('profil', $user->getRoleNames()->first());
            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);
        return $this->sendFailedLoginResponse($request);
    }


}
