<?php namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;

class Genre extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'genres';
	public  $timestamps = false;


    /**
     * Get the user's full name by concatenating the first and last names
     *
     * @return string
     */
    public function getNbVehiculesAttribute()
    {
        $nb_vehicules=Vehicule::where('genre','=',$this->ref)->count();
        
        return $nb_vehicules;
    }

    /**
     * Get the user's full name by concatenating the first and last names
     *
     * @return string
     */
    public function getFullNameAttribute()
    {
        $res="(".$this->ref.") ".$this->nom;
        return $res;
    }


    /**
    * Fiche Supprimable ?
    */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("GE_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;
        $nb=$this->NbVehicules;
        if($nb>0) return false;

        return true;
    }


}