<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;

class Vehicule extends Model {


	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'vehicules';
	public  $timestamps = true;
	

    /* Dates */
    public function getDates()
    {
            return array('date_emission','date_prem','date_prem_wf','date_visite','immat_prec_date');
    }


     public function getDateEmissionAttribute($value)
    {
        return ($this->attributes['date_emission']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_emission'])):"";
    }

     public function getDateEmissionUSAttribute($value)
    {
        return ($this->attributes['date_emission']!="0000-00-00")?date('Y-m-d', strtotime($this->attributes['date_emission'])):"";
    }

     public function getDatePremAttribute($value)
    {
        return ($this->attributes['date_prem']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_prem'])):"";
    }

      public function getDatePremWfAttribute($value)
    {
        return ($this->attributes['date_prem_wf']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_prem_wf'])):"";
    }

      public function getDateVisiteAttribute($value)
    {
        return ($this->attributes['date_visite']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_visite'])):"";
    }

      public function getImmatPrecDateAttribute($value)
    {
        return ($this->attributes['immat_prec_date']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['immat_prec_date'])):"";
    }


     public function getLocatairesAttribute()
    {
        $locataire=trim($this->locataire1_nom);
        $locataire.=(($locataire)?",":"").trim($this->locataire2_nom);
        $locataire.=(($locataire)?",":"").trim($this->locataire3_nom);
        return $locataire;
    }
    
    public function getVillageAttribute($value)
    {
        $village=Village::find($this->commune_id);
        return $village->nom;
    }

    public function getVillageBPAttribute($value)
    {
        $village=Village::find($this->commune_bp_id);
        return $village->nom;
    }

     public function getNumeroFormatedAttribute()
    {
        $txt=str_replace(" ","",$this->numero);
        $txt=str_pad($txt,9,"_", STR_PAD_LEFT);
        $txt=str_replace("_","&nbsp;",$txt);
        return $txt;
    }


}
