<div class="card card-info ui-sortable-handle">
    <div class="card-header" align="center">
        <span class="titre1">Propriétaire : </span><span class="btn-dark numero" style="padding:10px">{{ $nom }}</span>
        <div class="card-tools">
          <ul class="nav nav-pills ml-auto">
            <li class="nav-item">
              <a class="btn bg-primary" href="{{ url('home') }}" >Retour</a>
            </li>
          </ul>
        </div>

    </div>

    @if(!$vehicules)
        <div class='card-body card-info'>
            <div class=' alert' style="text-align:center">Aucun Propriétaire trouvé avec ce nom </div>
        </div>
    @else
        <div class='card-body card-info'>
            <div class="">
                <div class="card-header" align="center">
                    <h4>Vehicules de 
                        <span class="btn btn-dark numero">&nbsp;{!! $nom !!}&nbsp;</span>
                    </h4>
                </div>
                <div class='card-body card-info'>
                    <div class="">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Immatriculation</th>
                                    <th>Marque/Type</th>
                                    <th>DateEmission</th>
                                    <th>Proprietaires</th>
                                    <th>Commune</th>
                                    <th>Genre</th>
                                    <th>Declaration/Liquidation</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($vehicules as $vehicule)
                                    <tr>
                                        <td>{{ $vehicule->numero }}</td>
                                        <td>{{ $vehicule->marque."/".$vehicule->marque }}</td>
                                        <td>{{ $vehicule->date_emission }}</td>
                                        <td>
                                            {!! $vehicule->prop1_nom !!}
                                            @if($vehicule->prop2_nom)
                                                <br/><span class='small text-muted'>{!! $vehicule->prop2_nom !!}</span>
                                                <span class="right badge badge-warning">2nd</span>
                                            @endif
                                        </td>
                                        <td>{{ $vehicule->Village }}</td>
                                        <td>{{ $vehicule->genre }}</td>
                                        <td>
                                            @if($vehicule->declaration_num)
                                                {{ "DEC:".$vehicule->declaration_num }}
                                            @endif
                                            @if($vehicule->declaration_liq)
                                                {{ " LIQ:".$vehicule->declaration_liq }}
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            <tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>




