<?php 
namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\MyApp;
use App\Models\Vehicule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use View;
use DB;


class InfoPlaqueController extends Controller {

    /*
    public function index($msg="")
    {
        dd('de');
        return View::make('vehicules.api.api_chercher', [
            "msg" => $msg
        ]);
    }
        */

    
    public function proprietaire($numero) {
        return $this->getProprietaire($numero);
    }

    public function chercher(Request $request )
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($request->numero) return $this->getProprietaire($request->numero);
        if($request->nom) return $this->getVehicules($request->nom);
        $msg="Saisie incorrecte";
        Session::flash('message', $msg);

        return $this->index("Saisie incorrecte");
    }


    public function getProprietaire($numero)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $numero=str_replace(" ","",$numero);
        $vehicule=Vehicule::where(DB::raw("replace(numero,' ','')"),'=',$numero)->first();
        if(!$vehicule) $vehicule="";
        $mode="numero";
        $villages = MyApp::getVillagesPop();
        $genres = MyApp::getGenresPop();
        $districts=MyApp::getDistrictPop();
        $energies=MyApp::ENERGIES;
        $onglet_actif='o_immatriculation';

        return View::make('vehicules.show', [
            'vehicule' => $vehicule,  'numero' => $numero, 'mode' => $mode, 'onglet_actif' => $onglet_actif,
            "genres" => $genres,"energies" => $energies,'districts'=>$districts,'villages'=>$villages
        ]);

        return View::make('vehicules.info', [
            'vehicule' => $vehicule, 'numero' => $numero, 'mode' => $mode
        ]);
    }


    public function getVehicules($nom)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $nom=str_replace(".","",$nom);
        $nom=str_replace(" ","%",$nom);
        $vehicules_obj=Vehicule::
            where(DB::raw("replace(prop1_nom,'.','')"),'like',$nom."%")
            ->orwhere(DB::raw("replace(prop2_nom,'.','')"),'like',$nom."%");

        $limit=5;
        if($vehicules_obj->count()>$limit) {
            $vehicules_obj=$vehicules_obj->limit(5);
            $limit=5;
        } else  $limit=0;

        $vehicules=$vehicules_obj->get();
        if(!$vehicules) $vehicules="";
        $mode="nom";
        $nom=str_replace("%"," ",$nom);
      


        return View::make('vehicules.info', [
            'vehicules' => $vehicules, 'nom' => $nom, 'limit' => $limit, 'mode' => $mode
        ]);
    }


}