<div class="card card-info ui-sortable-handle">
    <div class="card-header" align="center">
        <span class="titre1">Recherche : </span><span class="btn-dark numero" style="padding:10px">{{ $nom }}</span>
        <div class="card-tools">
          <ul class="nav nav-pills ml-auto">
            <li class="nav-item">
              <a class="btn bg-primary" href="{{ url('home') }}" >Retour</a>
            </li>
          </ul>
        </div>

    </div>

    @if(!$vehicules)
        <div class='card-body card-info'>
            <div class=' alert' style="text-align:center">Aucun Propriétaire trouvé avec ce nom </div>
        </div>
    @else
        <div class='card-body '>
            <div class="card-header" align="center">
                <h4>Vehicules de 
                    <span class="btn btn-dark numero">&nbsp;{!! $nom !!}&nbsp;</span>
                </h4>
                @if($limit>0)
                    <h5 class="text-secondary">Le résultat dépasse la limite de {{ $limit }} véhicules. Seuls les {{ $limit }} premiers sont affichés. </h5> 
                @endif
            </div>
            <div class='card-body card-info'>
                <div class="row" >

                    <div class="col-md-12" align="center">
                        <table id="_table" class="table table-hover ">
                            <thead>
                                <tr>
                                    <th>Immatriculation</th>
                                    <th>Marque/Type</th>
                                    <th>DateEmission</th>
                                    <th>Proprietaires</th>
                                    <th>Commune</th>
                                    <th>Genre</th>
                                    <th>Declaration/Liquidation</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($vehicules as $vehicule)
                                    <tr>
                                        <td><a class="btn btn-sm bg-info" href="{{ url('proprietaire/'.$vehicule->numero) }}">{{ $vehicule->numero }}</a></td>
                                        <td>{{ $vehicule->marque."/".$vehicule->marque }}</td>
                                        <td>{{ $vehicule->date_emission }}</td>
                                        <td>
                                            {!! $vehicule->prop1_nom !!}
                                            @if($vehicule->prop2_nom)
                                                <br/><span class='small text-muted'>{!! $vehicule->prop2_nom !!}</span>
                                                <span class="right badge badge-warning">2nd</span>
                                            @endif
                                        </td>
                                        <td>{{ $vehicule->Village }}</td>
                                        <td>{{ $vehicule->genre }}</td>
                                        <td>
                                            @if($vehicule->declaration_num)
                                                {{ "DEC:".$vehicule->declaration_num }}
                                            @endif
                                            @if($vehicule->declaration_liq)
                                                {{ " LIQ:".$vehicule->declaration_liq }}
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            <tbody>
                        </table>
                    </div>

            </div>
        </div>
    @endif
</div>


@section('scripts')
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": false,
      "responsive": true, 
      "autoWidth": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'><'col-sm-4'p>>",
    })


  });
</script>
@endsection




