<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;


Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::get('D', 'App\Http\Controllers\Api\InfoPlaqueController@index')->withoutMiddleware("throttle:api");
Route::post('chercher', 'App\Http\Controllers\Api\InfoPlaqueController@chercher')->withoutMiddleware("throttle:api");
Route::get('plaque/{numero?}', 'App\Http\Controllers\Api\InfoPlaqueController@getProprietaire')->withoutMiddleware("throttle:api");
Route::get('conducteur/{nom?}', 'App\Http\Controllers\Api\InfoPlaqueController@getVehicules')->withoutMiddleware("throttle:api");
Route::get('login2', 'App\Http\Controllers\Api\ApiLoginController@login_visu')->withoutMiddleware("throttle:api");

Route::post('/login_visu', 'App\Http\Controllers\Auth\LoginController@login_visu');
Route::get('/trouve', 'App\Http\Controllers\Auth\LoginController@login_api');