<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Structures\Etablissement;
use App\Models\Structures\Academie;
use App\Models\Structures\Niveau;
use App\Models\Structures\SessionStage;
use App\Models\Structures\Classe;
use App\Models\Structures\Secteur;
use App\Models\Structures\Soussecteur;
use App\Models\Structures\Diplome;
use App\Models\MyApp;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\ClasseRequest;
use DB;

class AgendasController extends Controller {
    private $menu='agendas';
    private $submenu='classes';


    public function index()
    {
        //if(!($user=Auth::user())) return Redirect::route( 'login' );
        //if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter classes")) return Redirect::route('home');

        $withHeader=true;
        $withHero=false;
        $withClient=false;
        $withService=false;
        $withFooter2=false;

        $academies=Academie::select("code","nom")->orderby('nom','ASC')->get();//->pluck('nom','code')->toArray();
        $niveaux=Niveau::select("id","nom")->orderby('id','ASC')->get();
        $secteurs=Secteur::select("id","nom")->orderby('id','ASC')->get();
        $sous_secteurs=Soussecteur::select("id","nom")->orderby('id','ASC')->get();
        $diplomes=Diplome::select("id",db::raw("CONCAT(libelle,'-',specialite) as libelle"))->where('date_fin','=','0000-00-00')->orderby('id','ASC')->get();
        $lycees=Etablissement::where('type_etablissement','like','Ly%')
            ->orderby('nom_etablissement','ASC')->get();
        $colleges=Etablissement::where('type_etablissement','like','Col%')
            ->orderby('nom_etablissement','ASC')->get();

        $semaines=MyApp::week2day2tab();
        $classe="";
        $sessions = SessionStage::where("date_deb","like",date('Y')."%")->get();

        $classes=Classe::select('id','nom')->orderby("nom","asc")->get();


        return View::make('agendas.index', [
            'menu' => $this->menu,'submenu' => $this->submenu,
            'academies'=>$academies,'niveaux'=>$niveaux,'lycees'=>$lycees,'colleges'=>$colleges,
            'classes'=>$classes,'sessions'=>$sessions,'semaines'=>$semaines,
            'secteurs'=>$secteurs,'sous_secteurs'=>$sous_secteurs,'diplomes'=>$diplomes,
            'withHeader' => $withHeader,'withHero' => $withHero,'withClient' => $withClient,
            'withService' => $withService, 'withFooter2' => $withFooter2
        ]);

    }

}