<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Eleve;
use App\Models\Classe;
use App\Models\Etablissement;
use App\Models\Commune;
use App\Models\Enseignant;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\EleveRequest;

class ElevesController extends Controller {

    private $menu='structures';
    private $submenu='structures';
    private $message='';

    public function index($id_classe="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter eleves")) return Redirect::route('home');

        $classes=Classe::select('id','nom')->pluck('nom','id')->toArray();
        $classe="";$eleves="";
        if(!$id_classe) $id_classe=Session::get('id_classe' ); 
        if($id_classe) {
            Session::put('id_classe', $id_classe); 
            $eleves = Eleve::where('id_classe',$id_classe)->get();
            $classe= Classe::find($id_classe);
        }

        return View::make('structures.eleves.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'eleves' =>$eleves,'classes' =>$classes,
            'classes' => $classes,'classe' => $classe,
        ]);
    }

    public function index_filtre($id_classe)
    {
        return $this->index($id_classe);
    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $mode="create";
        
        $t_classes=array();
        $classes = Classe::all();
        foreach($classes as $classe) $t_classes[$classe->id]=$classe->nom;

        $enseignants=array();
        $t_enseignants = Enseignant::orderby('nom')->get();
        foreach($t_enseignants as $enseignant) $enseignants[$enseignant->id]=$enseignant->NomComplet;

        $t_communes=array();
        $communes = Commune::all();
        foreach($communes as $commune) $t_communes[$commune->id]=$commune->nom;

        return View::make('structures.eleves.create',[
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
                "t_classes" => $t_classes,
                "t_communes" => $t_communes,
                'enseignants' => $enseignants,
            ]);
    }

    public function store(EleveRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter eleves")) return Redirect::route('home');

        $eleve = $this->setData($request);
        $msg="La fiche de l'élève ".$eleves->nom." a été créée";
        Session::flash('success', $msg); 
        return Redirect::to('/eleves');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier eleves")) return Redirect::route('home');

        $eleve = Eleve::find($id);
        $classes = Classe::orderby('nom','ASC')->pluck('nom','id')->toArray();
        $enseignants = Enseignant::orderby('nom','ASC')->pluck(db::raw('CONCAT(nom," ",prenom)'),'id')->toArray();
        $communes = Commune::orderby('nom','ASC')->pluck('nom','id')->toArray();

        return View::make('structures.eleves.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'eleve' => $eleve,
            "classes" => $classes,
            "communes" => $communes,
            'enseignants' => $enseignants,
            ]);
    }
 
    public function update($id,EleveRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier enseignants")) return Redirect::route('home');

        $eleve = $this->setData($request,$id);
        $msg="La fiche de l'élève ".$eleve->NomComplet." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/eleves');
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter eleves")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        Eleve::destroy($id);
        return Redirect::to('/eleves');
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $eleve = new Eleve;
        else $eleve = Eleve::find($id);

        $eleve = Eleve::find($id);
        $eleve->nom=strtoupper($request->nom);
        $eleve->ine=strtoupper($request->ine);
        $eleve->prenom=$request->prenom;
        $eleve->prenom2=$request->prenom2;
        $eleve->sexe=($request->sexe);
        $eleve->adresse=$request->adresse;
        $eleve->cp=$request->cp;
        $eleve->id_commune=$request->id_commune;
        $eleve->email=$request->email;
        $eleve->tel=$request->tel;
        $date=$request->date_naissance;
        $eleve->date_naissance= ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $eleve->id_classe=$request->id_classe;
        $eleve->save();

        return $eleve;
    }

    public function stagiaires_contact($id_ent_tuteur)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $contact=Contact::find($id_ent_tuteur);
        $eleves = Eleve::where('');

        return View::make('structures.eleves.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'structures.eleves' => $eleves,
        ]);
    }

}