<?php

namespace App\Http\Controllers;

use View;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;

class HomeController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Fermeture d'une iframe pop - utilisé pour les suppressions de session
     *
     * @return void
     */
    public function closepop()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return view::make('forms.closepop',["user"=>$user]);
    }

    public function index()
    {

        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $dashboard_title = "";

        
        if($user->hasRole('ADMINISTRATEUR')||$user->hasRole('ADMINISTRATEUR FONCTIONNEL')) return $this->index_admin($user);

        $this->menu='home';
        $this->submenu='';

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $this->menu
        ]);
    }

    public function index_admin($user)
    {
        $dashboard_title = "";
        $sep="<br/>";
        $this->menu='home';
        $this->submenu='';


        return view::make('home',[
            "user"=>$user,"menu_home" => $this->menu,
            "dashboard_title"=>$dashboard_title,
            
        ]);
    }



}
