<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Niveau;
use App\Models\Classe;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\NiveauRequest;


class NiveauxController extends Controller {

    private $menu='parametres';
    private $submenu='niveaux';

    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter niveaux")) return Redirect::route('home');

        $niveaux = Niveau::all();

        return View::make('structures.niveaux.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'niveaux' => $niveaux,
        ]);
    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter niveaux")) return Redirect::route('home');

        $mode="create";

        return View::make('structures.niveaux.create',[
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'menu' => $this->menu,
        ]);
    }

    public function store(NiveauRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter niveaux")) return Redirect::route('home');

        $niveau = $this->setData($request);
        $msg="Le Niveau ".$niveau->nom." a été créée";
        Session::flash('success', $msg); 
        return Redirect::to('/niveaux');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier niveaux")) return Redirect::route('home');

        $niveau = Niveau::find($id);

        return View::make('structures.niveaux.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'niveau' => $niveau,
            ]);
    }
 
    public function update($id,NiveauRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier niveaux")) return Redirect::route('home');

        $niveau = $this->setData($request,$id);
        $msg="Le Niveau ".$niveau->nom." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/niveaux');
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter niveaux")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("supprimer niveaux")) return Redirect::route('home');

        //Pas de suppression si classes
        $nb=Classe::where("id_niveau","=",$id)->count();
        if($nb>0) return;
        Niveau::destroy($id);
 
        return Redirect::to('/niveaux');
    }


    public function setData($request,$id="")
    {
        if($id=="") $niveau =  new Niveau;
        else $niveau = Niveau::find($id);

        $niveau->nom=$request->nom;
        $niveau->save();

        return $niveau;
    }
}