<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DB;


class FiliereCategorie extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'filieres_categories';

    public function getCanDeleteAttribute()
    {
    	if(!($user=Auth::user())) return Redirect::route( 'login' );
    	if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("supprimer filières categories")) return false;

        $nb=Filiere::where('id_filiere_categorie','=',$this->id)->first();
        if(!$nb) return true;
        return false;
    }

}
