<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DB;


class Niveau extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'niveaux';

	public function getNbClassesAttribute()
	{
		$nb = DB::table('classes')
            ->where('classes.id_niveau', '=', $this->id)
            ->count();

	    return $nb;
	 }

	public function getNbElevesAttribute()
	{
		$nb = DB::table('eleves')
            ->join('classes', 'eleves.id_classe', '=', 'classes.id')
            ->join('niveaux', 'classes.id_niveau', '=', 'niveaux.id')
            ->where('niveaux.id','=',$this->id)
            ->count();

	    return $nb;
	 }

	public function getNbStagiairesAttribute()
	{
		$nb = DB::table('stages')
			->join('eleves', 'stages.id_eleve', '=', 'eleves.id')
            ->join('classes', 'eleves.id_classe', '=', 'classes.id')
            ->join('niveaux', 'classes.id_niveau', '=', 'niveaux.id')
            ->where('niveaux.id','=',$this->id)
            ->count();

	    return $nb;
	 }


    public function getCanDeleteAttribute()
    {
    	if(!($user=Auth::user())) return Redirect::route( 'login' );
    	if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("supprimer niveaux")) return false;

        $nb=$this->NbClasses;
        if($nb==0) return true;
        return false;
    }
}
