@extends('layouts.dash')
@section('title') Utilisateurs @stop
@section('title_card',"Utilisateur")
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th >Nom</th>
                        <th width='10%'>Identifiant</th>
                        <th width='10%'>Rôles</th>
                        <th width='10%'>Dernière connexion</th>
                        <th width='75px'>
                            @if($user->can("ajouter utilisateurs") || $user->hasRole("ADMINISTRATEUR"))
                            <a href="{!! url('users/create') !!}" class="btn btn-sm btn-success">
                                <span class='fa fa-plus'></span>&nbsp;Nouvel utilisateur</a> 
                            @endif
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($users_list as $user_row)
                    <tr>
                        <td>
                            <a href="{!! url('users/'.$user_row->id) !!}" >{!! $user_row->name !!}</a>
                            @if(!$user_row->actif)
                                <span class="right badge badge-danger">Inactif</span>
                            @endif
                        </td>
                        <td nowrap>{!! $user_row->email !!}</td>
                        <td nowrap>{!! $user_row->getRoles(); !!}</td>
                        <td nowrap>{!! $user_row->last_connection !!}</td>
                        <td nowrap>
                            <a href="{!! url('users/'.$user_row->id) !!}/edit" class="btn btn-sm btn-info pull-left" style="margin-right: 3px;">
                                <span class='fa fa-pencil'></span>
                            </a>

                            @if((!$user->hasRole("ADMINISTRATEUR")) && (count($user_row->getRoleNames())==0)&& (!$user_row->hasAnyDirectPermission()))
                                {{ html()->form('DELETE', url('/users/'. $user_row->id))->open() }}   
                                {{ csrf_field() }}
                                <button class="btn btn-sm btn-danger">
                                    <span class='fa fa-trash'></span>
                                </button>
                                {{ html()->form()->close() }}
                             @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>

            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection