@extends('layouts.dash_base')

@section('content')
    <!-- ======= Featured Section ======= -->
    <section id="featured" class="featured">
        <div class="container" style="">

            {{ html()->form('POST', url('/users'))->open() }}   
            <div class="row agenda-box" >
                <div class="col-lg-12">
                    <div class="row">
                        <h3><i class="bi bi-funnel"></i>Filtrer les données <small>{!! $lycees->count() !!} Lycées &nbsp;&nbsp;&nbsp;{!! $colleges->count() !!} Collèges</small></h3>
                    </div>
                    <div class="row">
                        <div class="col-lg-3">
                            <h4 >Académie</h4>
                            <select id='sel_academie' class="form-control" style="margin-bottom:30px">
                                @foreach($academies as $academie)
                                    <option id='id_opt_academie_{!! $academie->code !!}' value='{!! $academie->code !!}'>{!! $academie->nom !!}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-2">
                            <h4 >Niveau</h4>
                            <select id='sel_academie' class="form-control" style="margin-bottom:30px">
                                @foreach($niveaux as $niveau)
                                    <option id='id_opt_niveau_{!! $niveau->id !!}' value='{!! $niveau->id !!}'>{!! $niveau->nom !!}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-3">
                            <h4 >Secteur</h4>
                            <select id='sel_academie' class="form-control" style="margin-bottom:30px">
                                @foreach($secteurs as $secteur)
                                    <option id='id_opt_secteur_{!! $secteur->id !!}' value='{!! $secteur->id !!}'>{!! $secteur->nom !!}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-4">
                            <h4 >Diplôme</h4>
                            <select id='sel_academie' class="form-control" style="margin-bottom:30px">
                                @foreach($diplomes as $diplome)
                                    <option id='id_opt_diplome_{!! $diplome->id !!}' value='{!! $diplome->id !!}'>{!! $diplome->NomComplet !!}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                        <h5>{!! $lycees->count() !!} Lycées &nbsp;&nbsp;&nbsp;{!! $colleges->count() !!} Collèges</h5>
                        </div>
                    </div>
                    
                </div>
            </div>
            {{ html()->form()->close() }}

            <br/>
            <div class="row agenda-box" style="padding:0px;">
                <div class="col-lg-12">
                    <i class="bi bi-card-checklist"></i>
                    <h3>Sessions de stage</h3>
                    @include("agendas.calendar")
                </div>
            </div>

        </div>
    </section><!-- End Featured Section -->
@endsection

@section('scripts')
<script>

</script>
@endsection

