@extends('layouts.dash')

@section('content')

        @if(session()->has('error'))
             <p class="alert alert-danger">{{session('error')}}</p>
        @endif

      <div class="content mt-3">
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Changer d'Utilisateur</strong>
                            </div>

                            <div class="card-body">
                                <div class="col-lg-max col-lg-offset-1 container-fluid">
                                    {{ html()->modelForm($user, 'PUT', url('/change_profil'))->open() }}
                                    <div class="row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                {!! html()->label('Utilisateur','utilisateur') !!}
                                                {!! html()->select('user_id')->options($users_list)->value(DB::table('users')->where('id', '=', $user->id)->pluck("id"))
                                                    ->placeholder('A définir')
                                                    ->attributes(['class' => 'form-control'])  !!}
                                            </div>
                                        </div>
                                    </div>

                                    <div class='form-group'>
                                        {!! html()->button('Valider')->value('Valider')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                                    </div>

                                    {{ html()->closeModelForm() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@endsection