@extends('layouts.dash')

@section('title') Diplômes @stop
@section('title_card',"Diplômes")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-body">
            <table id="_table" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='40%'>Nom</th>
                        <th width='1%'>Nom court</th>
                        <th>Filiere</th>
                        <th width='1px'>
                            @if($user->can("ajouter diplomes") || $user->hasRole("ADMINISTRATEUR"))
                            <a href="{!! url('diplomes/create') !!}" class="btn btn-sm btn-success">&nbsp;Nouveau<br/>diplome</a>   
                            @endif
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($diplomes as $diplome)
                    <tr class=''>
                        <td ><a href="{!! url('/diplomes/'.$diplome->id) !!}">{!! $diplome->nom !!}</a></td>
                        <td nowrap>{!! $diplome->nom_court !!}</td>
                        <td>{!! $diplome->nom_filiere !!}</td>
                        <td nowrap>
                            @if($diplome->CanDelete)
                                {{ html()->form('DELETE', url('/diplomes/'. $diplome->id))->open() }}   
                                {{ csrf_field() }}
                            @endif
                                <a title="Consulter" href="{!! url('/diplomes/'.$diplome->id) !!}" class="btn btn-info btn-sm">
                                    <span class='fa fa-eye'></span>
                                </a> 
                            @if($diplome->CanDelete)
                                <button class="btn btn-sm btn-danger"><i title="supprimer" class="fas fa-trash"></i></button>
                                {{ html()->form()->close() }}
                             @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable")
@endsection
