@extends('layouts.dash')

@section('title') Elèves @stop
@section('title_card',"Structures")
@section('subtitle_card',"Elèves")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <label>Classe</label>
                    {!! html()->select('select_id_classe')->options($classes)->value(($classe)?$classe->id:'')
                        ->placeholder('Choisir une Classe')
                        ->attributes(['id'=>'select_id_classe','class' => 'form-control','onchange'=>'select_filtre()']) 
                    !!} 
                </div>
            </div>

            <script>
                function select_filtre() {
                    var select_id_classe = document.getElementById('select_id_classe');
                    var select_id_classe = [...select_id_classe.selectedOptions].map(option => option.value);
                    var url="" ; 
                    if(select_id_classe=="") select_id_classe=0;
                    url="{!! url('eleves_list/') !!}/"+select_id_classe;
                    location.href=url;
                }
            </script>
        </div>
        @if($classe)
            <div class="card-body">
                <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                    <thead>
                        <tr>
                            <th>Nom</th>
                            <th width='1px'>DateNaiss.</th>
                            <th width='1px'>Email</th>
                            <th width='1px'>
                                @if($user->can("ajouter eleves") || $user->hasRole("ADMINISTRATEUR"))
                                <a href="{!! url('eleves/create') !!}" class="btn btn-sm btn-success">
                                    Nouvel élève</a>  
                                @endif 
                            </th>
                        </tr>
                    </thead>
         
                    <tbody>
                        @foreach ($eleves as $eleve)
                        <tr class=''>
                            <td><a href="{!! url('eleves/'.$eleve->id) !!}">{!! $eleve->nomcomplet !!}</a></td>
                            <td nowrap>{!! $eleve->DateNaissance !!}</td>
                            <td nowrap>{!! $eleve->email !!}</td> 
                            <td nowrap>
                                @if($eleve->CanDelete)
                                    {{ html()->form('DELETE', url('/eleves/'. $eleve->id))->open() }}   
                                    {{ csrf_field() }}
                                @endif
                                <a title="Consulter" href="{!! url('eleves/'.$eleve->id) !!}" class="btn btn-sm btn-info">
                                    <span class='fa fa-eye'></span>
                                </a>
                                @if($eleve->CanDelete)
                                    <button  title="Supprimer" class="btn btn-danger btn-sm"><span class='fa fa-trash'></span></button>
                                    {{ html()->form()->close() }}
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
    <script>
      $(function () {
        //Initialize Select2 Elements
        $('.select2').select2()

       })

        function select_classe() {
            //var classes=$('#classes').val();
            var select = document.getElementById('classes');
            var selected = [...select.selectedOptions].map(option => option.value);
            var url="" ; 
            if(selected=="") url="{!! url('eleves_list/0') !!}";
            else url="{!! url('eleves_list/') !!}/"+selected;
            location.href=url;

        }

        function select_groupe() {
            var select_groupe = document.getElementById('groupes');
            var selected_groupe = [...select_groupe.selectedOptions].map(option => option.value);
            var select_classe = document.getElementById('classes');
            var selected_classe = [...select_classe.selectedOptions].map(option => option.value);
            var url="" ; 
            if(selected_classe=="") url="{!! url('eleves_list/0') !!}";
            if(select_groupe=="") url="{!! url('eleves_list') !!}/"+selected_classe;
            else url="{!! url('eleves_list/') !!}/"+selected_classe+"/"+selected_groupe;
            location.href=url;

        }
    </script>
@endsection


