@extends('layouts.dash')

@section('title') Enseignants @stop
@section('title_card',"Enseignants")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-body">
            <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <!-- <th width='1%'>id</th> -->
                        <th>Nom</th>
                        <th width='5%'>Tel</th>
                        <th width='10%'>Email</th>
                        <th width='1%'>NbClasses</th>
                        <th width='1%'>Classes</th>
                        <th width='1%'>Référent</th>
                        <th width='1px'>
                            @if($user->can("ajouter enseignants") || $user->hasRole("ADMINISTRATEUR"))
                            <a href="{!! url('enseignants/create') !!}" class="btn btn-sm btn-success">
                                Ajouter un enseignant</a>  
                            @endif 
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($enseignants as $enseignant)
                    <tr class=''>
                        <!-- <td style='color:grey'>{!! $enseignant->id !!}</td> -->
                        <td nowrap><a href="{!! url('enseignants/'.$enseignant->id) !!}">{!! $enseignant->NomComplet !!}</a></td>
                        <td nowrap>{!! $enseignant->telHTML !!}</td>
                        <td nowrap>{!! $enseignant->email !!}</td>
                        <td align="center">{!! $enseignant->NbClasse !!}</td>
                        <td nowrap>{!! $enseignant->ListeClasse !!}</td>
                        <td nowrap>
                            @if($enseignant->ReferentNbInfo!="")
                                <button type="button" 
                                class="btn btn-outline-info" 
                                style='' 
                                data-toggle="modal" data-target="#detail_referent"">
                                {!! $enseignant->ReferentNbInfo !!}
                                </button>

                                <div class="modal fade" id="detail_referent" tabindex="-1" role="dialog" aria-labelledby="smallmodalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-lg" role="document">
                                        <div class="modal-content  bg-info">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="smallmodalLabel">
                                                    {!! $enseignant->NomComplet !!}<br/>référent pour :</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <p>{!! $enseignant->ReferentListeEleves !!}</p>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endif
                        </td>
                        <td nowrap >
                            @if($enseignant->CanDelete)
                                {{ html()->form('DELETE', url('/enseignants/'. $enseignant->id))->open() }}   
                                {{ csrf_field() }}
                            @endif
                            <a title="Consulter" href="{!! url('/enseignants/'.$enseignant->id) !!}" class="btn btn-info btn-sm">
                                <span class='fa fa-eye'></span>
                            </a> 
                            @if($enseignant->CanDelete)
                                <button class="btn btn-sm btn-danger"><i title="supprimer" class="fas fa-trash"></i></button>
                                {{ html()->form()->close() }}
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('scripts')
    @include("forms.scripts_datatable")
@endsection
