@extends('layouts.dash')

@section('title') Niveaux @stop
@section('title_card',"Structures")
@section('subtitle_card',"Niveaux")

@section('content')
    <div class="card">
        <div class="card-body">
           <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <th >Nom</th>
                        <th width='1%'>Nombre de&nbsp;classes</th>
                        <th width='1%'>Nombre d'élèves</th>
                        <th width='1%'>Nombre de&nbsp;stagiaires</th>
                        <th width='1px'>
                            @if($user->can("ajouter niveaux") || $user->hasRole("ADMINISTRATEUR"))
                            <a href="{!! url('niveaux/create') !!}" class="btn btn-sm btn-success">
                                Ajouter un niveau</span></a>   
                            @endif
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($niveaux as $niveau)
                    <tr class=''>
                        <td nowrap><a href="{!! url('/niveaux/'.$niveau->id) !!}">{!! $niveau->nom !!}</a></td>
                        <td align="center">{!! $niveau->NbClasses !!}</td>
                        <td align="center">{!! $niveau->NbEleves !!}</td>
                        <td align="center">{!! $niveau->NbStagiaires !!}</td>
                        <td align="left">
                            @if($niveau->CanDelete)
                                {{ html()->form('DELETE', url('/niveaux/'. $niveau->id))->open() }} 
                                {{ csrf_field() }}
                            @endif
                                <a title="Consulter" href="{!! url('/niveaux/'.$niveau->id) !!}" class="btn btn-info btn-sm">
                                    <span class='fa fa-eye'></span>
                                </a> 
                            @if($niveau->CanDelete)
                                <button  title="Supprimer" class="btn btn-danger btn-sm"><span class='fa fa-trash'></span></button>
                                {{ html()->form()->close() }}
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('scripts')
@include("forms.scripts_datatable")
@endsection