
<?php $__env->startSection('title'); ?> Utilisateurs <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Utilisateur"); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th >Nom</th>
                        <th width='10%'>Identifiant</th>
                        <th width='10%'>Rôles</th>
                        <th width='10%'>Dernière connexion</th>
                        <th width='75px'>
                            <a href="<?php echo url('users/create'); ?>" class="btn btn-sm btn-success">
                                <span class='fa fa-plus'></span>&nbsp;Nouvel utilisateur</a> 
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $users_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <a href="<?php echo url('users/'.$user_row->id); ?>" ><?php echo $user_row->name; ?></a>
                            <?php if(!$user_row->actif): ?>
                                <span class="right badge badge-danger">Inactif</span>
                            <?php endif; ?>
                        </td>
                        <td nowrap><?php echo $user_row->email; ?></td>
                        <td nowrap><?php echo $user_row->getRoles(); ?></td>
                        <td nowrap><?php echo $user_row->last_connection; ?></td>
                        <td nowrap>
                            <a href="<?php echo url('users/'.$user_row->id); ?>/edit" class="btn btn-sm btn-info pull-left" style="margin-right: 3px;">
                                <span class='fa fa-pencil'></span>
                            </a>

                            <?php if((!$user->hasRole("ADMINISTRATEUR")) && (count($user_row->getRoleNames())==0)&& (!$user_row->hasAnyDirectPermission())): ?>
                                <?php echo e(html()->form('DELETE', url('/users/'. $user_row->id))->open()); ?>   
                                <?php echo e(csrf_field()); ?>

                                <button class="btn btn-sm btn-danger">
                                    <span class='fa fa-trash'></span>
                                </button>
                                <?php echo e(html()->form()->close()); ?>

                             <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GPFMP\gpfmp_etablissement\resources\views/acces/users/index.blade.php ENDPATH**/ ?>