

<?php $__env->startSection('title'); ?> Diplômes <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Diplômes"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="card">
        <div class="card-body">
            <table id="_table" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>Nom</th>
                        <th width='1%'>Nom court</th>
                        <th>Filiere</th>
                        <th width='1px'>
                            <a href="<?php echo url('diplomes/create'); ?>" class="btn btn-sm btn-success">&nbsp;Nouveau<br/>diplome</a>   
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $diplomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $diplome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class=''>
                        <td nowrap><a href="<?php echo url('/diplomes/'.$diplome->id); ?>"><?php echo $diplome->nom; ?></a></td>
                        <td nowrap><?php echo $diplome->nom_court; ?></td>
                        <td nowrap><?php echo $diplome->nom_filiere; ?></td>
                        <td nowrap>
                            <?php if($diplome->CanDelete): ?>
                                <?php echo e(html()->form('DELETE', url('/diplomes/'. $diplome->id))->open()); ?>   
                                <?php echo e(csrf_field()); ?>

                            <?php endif; ?>
                                <a title="Consulter" href="<?php echo url('/diplomes/'.$diplome->id); ?>" class="btn btn-info btn-sm">
                                    <span class='fa fa-eye'></span>
                                </a> 
                            <?php if($diplome->CanDelete): ?>
                                <button class="btn btn-sm btn-danger"><i title="supprimer" class="fas fa-trash"></i></button>
                                <?php echo e(html()->form()->close()); ?>

                             <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GPFMP\gpfmp_etablissement\resources\views/structures/diplomes/index.blade.php ENDPATH**/ ?>