<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Etablissement;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\EtablissementRequest;

class EtablissementsController extends Controller {

    private $menu='etablissements';
    private $submenu='';
    private $title='Etablissements';

    public function index($type_etablissement="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter etablissements")) return Redirect::route('home');

        if($type_etablissement) $etablissements =Etablissement::where('type_etablissement','=',$type_etablissement)->orderby('rne')->get();
        else $etablissements =Etablissement::all();
        return View::make('etablissements.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'title' => $this->title,
            'etablissements'=>$etablissements,
            'type_etablissement'=>$type_etablissement       
        ]);
    }


    public function index_lycee()
    {
        $this->title='Lycées';
        return $this->index("Lycée");
    }

    public function index_college()
    {
        $this->title='Collèges';
        return $this->index("Collège");
    }

    public function create()
    {

    }

    public function store(EtablissementRequest $request)
    {

    }
 
    public function edit($id,$mode="edit")
    {

    }
 
    public function update($id,EtablissementRequest $request)
    {

    }
 
    public function show($id)
    {

    }

    public function destroy($id)
    {

    }


    public function setData($request,$id="")
    {

    }

}