<?php namespace App\Http\Controllers;

use App\User;
use App\Models\Niveau;
use App\Models\Classe;
use App\Models\Enseignant;
use App\Models\Eleve;
use App\Models\Etablissement;
use App\Models\Commune;
use App\Models\MyApp;
use App\Models\Importation;
use DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\EleveRequest;
use Illuminate\Http\Request;

//use App\Http\Controllers\Controller;
//use Nathanmac\Utilities\Parser\Formats\FormatInterface;
//use Nathanmac\Utilities\Parser\Facades\Parser;

class ImportationsController extends Controller {

    private $menu='structures';
    private $submenu='importations';

    private $t_tables =["classes","eleves","entreprises","enseignants","responsables","maitres_de_stages"];
    private $destinationPath = 'uploads';
    private $etab_id_user="";


    public function index($t_msg=array())
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $t_info=array();
        foreach($this->t_tables as $table) {
            $importation_last=Importation::where("fichier","=",$table)->orderby("date","DESC")->first();
            if($importation_last) {
                $t_info[$table]["date"]=$importation_last->date;
                $t_info[$table]["nb_lignes"]=$importation_last->nb_lignes;
                $t_info[$table]["statut"]=$importation_last->statut;
            }
        }
        return View::make('structures.importations.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            "t_tables" => $this->t_tables,
            "t_info" => $t_info,
            "t_msg" => $t_msg,  
        ]);
    }

    public function getDetailFormat($table)
    {
        $t_detail=['libelle'=>'','file'=>''];

        if($table=="eleves") {
            $t_detail['libelle']="Nom,Prenom,Date_naissance,Sexe,Classe";
            $t_detail['file']="modele_eleves.csv";
        }

        if($table=="classes") {
            $t_detail['libelle']="Nom,Niveau,Diplome";
            $t_detail['file']="modele_eleves.csv";
        }
        
        if($table=="enseignants") {
            $t_detail['libelle']="civilité;nom;disciplines;classesPP;email;telmobile;telfixe".
                "<br><i style='background-color:white;color:grey'>Dans le cas de plusieurs classes pour un enseignants, 
                les valeurs doivent être séparées par une virgule (<span style='foont-weight:bold;color:red;'>,</span>)</i>";
            $t_detail['file']="modele_eleves.csv";
        }

        return $t_detail;
    }


    public function importe(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $mode=$request->mode;
        if($mode=="siecle") return $this->importe_siecle($request);
        if($mode=="csv") return $this->importe_csv($request);
        return;
    }

    public function importe_siecle($request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $etablissement=Etablissement::find($user->id_etablissement);
        if(!$etablissement) {
            return redirect()->back()->withInput()->withErrors(['message1'=>'Vous devez avoir un établissement associé à votre compte']);   
        }
        $file=$request->file();
        if(!$file) return  redirect()->back()->withInput()->withErrors(['message3'=>"Fichier introuvable"]);   
        $id_file="file_xml";

        $file_name=$file[$id_file]->getClientOriginalName();
        $file_extension=$file[$id_file]->getClientOriginalExtension();
        $file_getRealPath=$file[$id_file]->getRealPath();
        $file_size=$file[$id_file]->getSize();
        $file_mimetype=$file[$id_file]->getMimeType();
        $file[$id_file]->move($this->destinationPath,$file[$id_file]->getClientOriginalName());

        //ouverture du fichier
        $payload = file_get_contents($this->destinationPath."/".$file_name);
        $parsed = Parser::xml($payload);
        //Compte les éléments
        $eleves=$parsed["DONNEES"]["ELEVES"];
        $structures=$parsed["DONNEES"]["STRUCTURES"]["STRUCTURES_ELEVE"];
        $options=$parsed["DONNEES"]["OPTIONS"]["OPTION"];
        $adresses=$parsed["DONNEES"]["ADRESSES"]["ADRESSE"];
        //Comptee nb eleves
        $nb_eleves_xml=count($eleves["ELEVE"]);
        //NB elève actuels
        $nb_eleves=Eleve::
            join('classes','classes.id','=','eleves.id_classe')
            ->join('etablissements','etablissements.id','=','classes.id_etablissement')
            ->count();
        $import_statut="PRE";

        return View::make('structures.importations.prepa_xml', [
            'user' => $user,
            'nb_eleves' => $nb_eleves,
            'nb_eleves_xml' => $nb_eleves_xml,
            'file_name' => $file_name,
            'etablissement' => $etablissement,
            'import_statut' => $import_statut
           
        ]);
    }

    public function xml_importe_validation(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $file_name=$request->file_name;
        $truncate_eleves=(isset($request->init_base)&&($request->init_base))?1:0;

        //ouverture du fichier
        $payload = file_get_contents($this->destinationPath."/".$file_name);
        if(!$payload) return  redirect()->back()->withInput()->withErrors(['message3'=>"Fichier introuvable"]);   
        $parsed = Parser::xml($payload);
        //Compte les éléments
        $uaj=trim($parsed["PARAMETRES"]["UAJ"]);
        $eleves=$parsed["DONNEES"]["ELEVES"]["ELEVE"];
        $structures=$parsed["DONNEES"]["STRUCTURES"]["STRUCTURES_ELEVE"];
        $options=$parsed["DONNEES"]["OPTIONS"]["OPTION"];
        $adresses=$parsed["DONNEES"]["ADRESSES"]["ADRESSE"];

        $etablissement=Etablissement::find($user->id_etablissement);
        if(!$etablissement) {
            return redirect()->back()->withInput()->withErrors(['message1'=>'Vous devez avoir un établissement associé à votre compte']);   
        }

        if($uaj!=$etablissement->rne) {
            return redirect()->back()->withInput()->withErrors(['message1'=>"Ce fichier est une extraction de l'établissement ".$uaj." et pas de celui choisi en destinataire (".$etablissement->rne.")"]);   
        }
        //Suppressions des anciens
        if($truncate_eleves) {
            DB::table("stages")->truncate();
            DB::table("stage_avenants")->truncate();
            DB::table("sessions")->truncate();
            DB::table("sessions_classe")->truncate();
            DB::table("groupes_eleves")->truncate();
            DB::table("groupes")->truncate();
            DB::table("enseignants_classes")->truncate();
            DB::table("classes")->truncate();
            DB::table("eleves")->truncate();
        }

        //Importe Classes
        $nb_classes_xml=0;

        //Importe eleves
        $this->xml_importe_eleves($eleves,$adresses,$structures);
        $nb_eleves=Eleve::all()->count();
        $nb_classes=Classe::all()->count();

        if($nb_eleves==0) return  redirect()->back()->withInput()->withErrors(['message3'=>"Aucun élève"]);   

        $import_statut="VAL";
        return View::make('structures.importations.prepa_xml', [
            'user' => $user,
            'nb_eleves' => $nb_eleves,"nb_classes" => $nb_classes,
            'file_name' => $file_name,
            'etablissement' => $etablissement,
            'import_statut' => $import_statut
           
        ]);
    }

    public function xml_importe_eleves($eleves,$adresses,$structures)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $etablissement=Etablissement::find($user->id_etablissement);
        //FORMAT :
        /*
        "@ELEVE_ID" => "231886"
        "@ELENOET" => "4"
        "ID_NATIONAL" => "123141985KH"
        "ELENOET" => "4"
        "ID_ELEVE_ETAB" => "00004830693"
        "NOM_DE_FAMILLE" => "KAMODJI"
        "PRENOM" => "Marie-Odile"
        "PRENOM2" => "Cécile"
        "DATE_NAISS" => "20/08/2001"
        "DOUBLEMENT" => "0"
        "CODE_PAYS" => "100"
        "DATE_MODIFICATION" => "16/12/2021"
        "DATE_SORTIE" => "17/12/2021"
        "MEL" => "kamodjiodile@gmail.com"
        "CODE_REGIME" => "3"
        "DATE_ENTREE" => "16/12/2016"
        "VILLE_NAISS" => null
        "CODE_MOTIF_SORTIE" => "39"
        "CODE_SEXE" => "2"
        "TEL_PORTABLE" => "+687868333"
        "CODE_PAYS_NAT" => "100"
        "CODE_STATUT" => "ST"
        "CODE_DEPARTEMENT_NAISS" => "988"
        "CODE_COMMUNE_INSEE_NAISS" => "98818"
        "ADHESION_TRANSPORT" => "0"
        "CODE_PROVENANCE" => "1"
        "SCOLARITE_AN_DERNIER"  =W array(...)
        */
        $nb_eleves_xml=count($eleves);
        $nb_structures_xml=count($structures);

        $t_eleves_classe=[];
        $t_nom_structures=[];
        for($i=0;$i<$nb_structures_xml;$i++) {
            $t_structure=$structures[$i]["STRUCTURE"];
            $eleve_id=$structures[$i]["@ELEVE_ID"];
            foreach($t_structure as $code=>$nom_structure) {
                $t_eleves_classe[$eleve_id]=$t_structure["CODE_STRUCTURE"];
                if(!in_array($nom_structure,$t_nom_structures)) $t_nom_structures[]=$nom_structure;
            }
        }

        //CReation des classes
        for($i=0;$i<count($t_nom_structures);$i++) {
            $nom_classe=$t_nom_structures[$i];
            $classe=new Classe;
            $classe->id_etablissement=$etablissement->id;
            $classe->nom=$nom_classe;
            $classe->nom_court=$nom_classe;
            $classe->id_pp=null;
            $classe->id_niveau=MyApp::getNiveau($nom_classe);
            $niveau=Niveau::find($classe->id_niveau);
            if($classe->id_niveau==null) {
                $niveau=new Niveau;
                $niveau->nom=MyApp::getNiveauNom($nom_classe);
                if($niveau->nom!="") {
                    $niveau->save();
                    $classe->id_niveau=$niveau->id;
                } 
            }
            $classe->id_filiere=null;//MyApp::getFiliere($nom_classe);
            $classe->id_diplome=null;//MyApp::getDiplome($nom_classe);
            $classe->save();
        }

        $t_error=[];
        for($i=0;$i<$nb_eleves_xml;$i++) {
            $id_siecle=$eleves[$i]["@ELEVE_ID"];
            $eleve = new Eleve;
            $eleve->nom=$eleves[$i]["NOM_DE_FAMILLE"];
            $eleve->ine =isset($eleves[$i]["ID_NATIONAL"])?$eleves[$i]["ID_NATIONAL"]:null;
            $eleve->prenom=$eleves[$i]["PRENOM"];
            $eleve->prenom2=isset($eleves[$i]["PRENOM2"])?$eleves[$i]["PRENOM2"]:"";
            $eleve->sexe=isset($eleves[$i]["CODE_SEXE"])?(($eleves[$i]["CODE_SEXE"]=="2")?"F":"G"):"";
            $num_adresse=isset($eleves[$i]["ADRESSE_ID"])?$eleves[$i]["ADRESSE_ID"]:"";
            if($num_adresse) {
                $t_adresse=$this->xml_get_adresse($adresses,$num_adresse);
                $eleve->adresse=$t_adresse["adresse"];
                $eleve->cp=$t_adresse["cp"];
                $eleve->id_commune=$t_adresse["commune"];
            }
        
            $eleve->email=isset($eleves[$i]["MEL"])?$eleves[$i]["MEL"]:"";
            $eleve->tel=isset($eleves[$i]["TEL_PORTABLE"])?$eleves[$i]["TEL_PORTABLE"]:"";
            $date=$eleves[$i]["DATE_NAISS"];
            $eleve->date_naissance= ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;



            $classe_nom=isset($t_eleves_classe[$id_siecle])?$t_eleves_classe[$id_siecle]:null;
            $classe=Classe::where("nom","=",$classe_nom)->first();


            $eleve->id_classe=$classe?$classe->id:null;

            if($eleve->id_classe!=null) $eleve->save();
            else $t_error[]=$id_siecle;
        }


        return true;
    }

    public function xml_get_adresse($adresses,$num_adresse)
    {

        $t_adresse=["adresse"=>"","cp"=>"","commune"=>""];
        for($i=0;$i<count($adresses);$i++) {

            if($adresses[$i]["@ADRESSE_ID"]==$num_adresse) {
                $adr1=trim($adresses[$i]["LIGNE1_ADRESSE"]);
                $adr2=trim($adresses[$i]["LIGNE2_ADRESSE"]);
                $adr3=trim($adresses[$i]["LIGNE3_ADRESSE"]);
                $adr4=$adresses[$i]["LIGNE4_ADRESSE"];
                $t_adresse["adresse"]=$adr1;
                if($adr2!="") $t_adresse["adresse"].= "<br/>".MyApp::CleanString($adr2);
               // if($adr3!="") $t_adresse["adresse"].="\n".$adr3;
               // if($adr4!="") $t_adresse["adresse"].="\n".$adr4;



                $t_adresse["cp"]=$adresses[$i]["CODE_POSTAL"];
                $nom_commune=trim($adresses[$i]["LIBELLE_POSTAL"]);
                $id_commune=Commune::where('nom','like',$nom_commune);
                if(!$id_commune) {
                    $commune=new Commune;
                    $commune->nom=$adresses[$i]["LIBELLE_POSTAL"];
                    $commune->cp=$adresses[$i]["CODE_POSTAL"];
                    $commune->save();
                }
                $t_adresse["commune"]=isset($commune)?$commune->id:null;
            }
        }
        return $t_adresse;
    }

    /* ************************************* */
    /*                  CSV                  */
    /* ************************************* */
    public function import_csv_pop($table)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $t_detail=$this->getDetailFormat($table);
        $nom_modele="";
        return View::make('structures.importations.import_csv_pop', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'table' => $table,
            't_detail' => $t_detail,
            'nom_modele' => $nom_modele,
            ]);
    }

    /* Validation de l'importation */
    public function import_csv(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
  
        $table=$request->table;
        $msg="";$t_msg=[];
        $t_tablestoimport=array();
        $tables=$this->t_tables;
        $truncate=isset($request->truncate)?1:0;

        $separateur=";";
        $file[$table] = $request->file('file_csv');
        if($file[$table]) {
            $t_tablestoimport[]=$table;
            $file_name[$table]=$file[$table]->getClientOriginalName();
            $file_extension[$table]=$file[$table]->getClientOriginalExtension();
            $file_getRealPath[$table]=$file[$table]->getRealPath();
            $file_size[$table]=$file[$table]->getSize();
            $file_mimetype[$table]=$file[$table]->getMimeType();
            $file[$table]->move($this->destinationPath,$file[$table]->getClientOriginalName());
        }
      
        if($table=="enseignants") {
            $nb_import=$this->importe_data($table,$file_name[$table],$separateur,1,$truncate);
            $t_msg[$table]=($nb_import>0)?$nb_import." Enseignants importés ":"Aucune données importée";
        }
        if($t_msg[$table]!="") $this->add_importations($table,$file_getRealPath[$table],$user->id,$truncate);

        return $this->index_csv($t_msg);
    }


    public function importe_data($table,$filename,$sep=";",$ligneentete=0,$truncate=false)
    {
        if($truncate) {
            DB::table($table)->truncate();
            if($table=="entreprises") DB::table("contacts")->truncate();
        }

        $i=0;$nb_import=0;
        $file  = fopen($this->destinationPath."/".$filename, "r");
        while (($line = fgetcsv($file, 1000, $sep)) !== false) {
            $i++;
            if( ($i>$ligneentete) && ($line!="")) {
                $this->{"importe_ligne_".$table}($line);   
                $nb_import++;
            }
        }

        /*
        while(! feof($file)) {
            $i++;
            $line = fgets($file);
            if( ($i>=$ligneentete) && ($line!="")) {
                $this->{"importe_ligne_".$table}($line);   
                $nb_import++;
            }

        }
        */
        return $nb_import;
    }

    /*
    public function importe_csv(Request $request,$table)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $msg="";
        $t_tablestoimport=array();
        $tables=$this->t_tables;
        $separateur=array();
        foreach($tables as $table) {
            $separateur[$table]=$request->{"separateur_".$table };
            $file[$table] = $request->file($table);
            if($file[$table]) {
                $t_tablestoimport[]=$table;
                $file_name[$table]=$file[$table]->getClientOriginalName();
                $file_extension[$table]=$file[$table]->getClientOriginalExtension();
                $file_getRealPath[$table]=$file[$table]->getRealPath();
                $file_size[$table]=$file[$table]->getSize();
                $file_mimetype[$table]=$file[$table]->getMimeType();
                $file[$table]->move($this->destinationPath,$file[$table]->getClientOriginalName());
            }
        }
        //Ouvertue
        $nb_import=0;
        $t_msg=array();
        foreach($t_tablestoimport as $table) {
            $t_msg[$table]="";
            if($table=="classes")  {
                $nb_import=$this->importe_data($table,$file_name[$table],$separateur[$table],1,1);
                $t_msg[$table]=($nb_import>0)?$nb_import." Classes importées (avec filières et niveaux)":"Aucune données importée";
            }

            if($table=="eleves") {
                $nb_import=$this->importe_data($table,$file_name[$table],$separateur[$table],1,1);
                $t_msg[$table]=($nb_import>0)?$nb_import." Elèves importés ":"Aucune données importée";
            }

           if($table=="entreprises") {
                $nb_import=$this->importe_data($table,$file_name[$table],$separateur[$table],2,1);
                $t_msg[$table]=($nb_import>0)?$nb_import." Entreprises importées (et responsables) ":"Aucune données importée";
            }

            if($table=="enseignants") {
                $nb_import=$this->importe_data($table,$file_name[$table],$separateur[$table],1,1);
                $t_msg[$table]=($nb_import>0)?$nb_import." Enseignants importés ":"Aucune données importée";
            }

            if($table=="responsables") {
                $nb_import=$this->importe_data($table,$file_name[$table],$separateur[$table],1,1);
                $t_msg[$table]=($nb_import>0)?$nb_import." Responsables importés ":"Aucune données importée";
            }

            if($table=="maitres_de_stages") {
                $nb_import=$this->importe_data($table,$file_name[$table],$separateur[$table],1,1);
                $t_msg[$table]=($nb_import>0)?$nb_import." Maitres de stage importés ":"Aucune données importée";
            }

            if($t_msg[$table]!="") $this->add_importations($table,$file_getRealPath[$table],$user->id,$nb_import);
        }
        return $this->index_csv($t_msg);
    }
    */

    public function add_importations($table,$path,$user_id,$nb_import)
    {
        //ajout dans table Importations
        $importation=new Importations();
        $importation->fichier=$table;
        $importation->chemin=$path;
        $importation->nb_lignes=$nb_import;
        $importation->id_user=$user_id;
        $importation->date=date("Y-m-d H:i:s");
        $importation->statut=($nb_import>0)?"OK":"NOK";
        $importation->save();
    }

/*
    public function importe_ligne_classes($t_values)
    {
        //FORMAT : Nom,Niveau,Filière,Prof. principal;
        //NUM COLS : 0 / 1 / 2 / 3 /6
        $t_cols=["nom"=>0,"niveau"=>1,"filiere"=>2,"pp"=>3];

        //création/recherche des filières
        $nom_filiere=str_replace("\"","",$t_values[$t_cols["filiere"]]);
        $filiere=Filiere::where("nom","=",$nom_filiere)->first();

        if(!$filiere) {
            $filiere=new Filiere();
            $filiere->nom=$nom_filiere;
            $filiere->save();
        }

        //création/recherche des niveaux
        $nom_niveau=$t_values[$t_cols["niveau"]];
        $niveau=Niveau::where("nom","=",$nom_niveau)->first();
        if(!$niveau) {
            $niveau=new Niveau();
            $niveau->nom=$nom_niveau;
            $niveau->save();
        }

        //Recherche du PP
        $nom_enseignant=$t_values[$t_cols["pp"]];
        $t_nom_enseignant=explode(" ",$nom_enseignant);
        if($t_nom_enseignant[0]=="M") $nom_enseignant=substr($nom_enseignant,2);
        else if($t_nom_enseignant[0]=="M.") $nom_enseignant=substr($nom_enseignant,3);
        else if($t_nom_enseignant[0]=="Mme") $nom_enseignant=substr($nom_enseignant,4);
        //if($t_values[$t_cols["pp"]]=="M. NAZEYROLLAS PHILIPPE") dd($nom_enseignant);
        $nom_enseignant=str_replace("Mme","",$nom_enseignant);
        $enseignant=Enseignant::where(DB::raw("CONCAT(nom,' ',prenom)"),"like",$nom_enseignant)->first();   
        $classe=new Classe();
        $classe->nom=$t_values[0]; //nom
        $classe->nom_court=$t_values[0]; 
        $classe->id_niveau=$niveau->id; 
        $classe->id_filiere=$filiere->id; 
        if($enseignant) $classe->id_pp=$enseignant->id; 
        $classe->save();
    }

    public function importe_ligne_eleves($t_values)
    {
        //FORMAT : 0=>NOM / 1=>PRENOM / 2=>DATENAISS / 3=>SEXE / 4=>CLASSE 
        $t_cols=["nom"=>0,"prenom"=>1,"date_naissance"=>2,"sexe"=>3,"classe"=>4];

        //créatioon/recherche des niveaux
        $nom_classe=$t_values[$t_cols["classe"]];
        $classe=Classe::where("nom","=",$nom_classe)->first();

        
        $eleve=new Eleve();
        $eleve->nom=$t_values[0]; //nom
        $eleve->prenom=$t_values[1]; 
        $eleve->date_naissance=($t_values[2]!="")?date('Y-m-d', strtotime(str_replace('/', '-', $t_values[2]))):null; 
        $eleve->sexe=$t_values[3]; 
        
        if($classe) $eleve->id_classe=$classe->id; 
        $eleve->save();
    }


    public function importe_ligne_entreprises($t_values)
    {
        // FORMAT : 0=>NOM / 1=>Siege / 2=>Activite / 3=>APE / 4=>Métiers / 5=AccepteStg
        // F18=>Adresse1, 19=>Adresse2, 20=>Adresse3, 21=>Adresse4, 22=>CP, 23 Ville, 25 Pays,
        // F26 => TelFixe, 27=>Portable =>, 29=>Email, 30=>SiteWeb, 31=>ridet
        // F, 32=>URSAFF, 33=>AssuranceLib, 34=>Assurance Police, 
        // F38=>Civilité,39=>Nom,40=>Prénom,41=>Fonction,42=>Fixe,44=>Postable,45=>Email,
        


        //$t_cols=["nom"=>0,"prenom"=>1,"date_naissance"=>2,"sexe"=>3,"classe"=>4];

        //$t_values=explode($sep,$line);
        $entreprise=new Entreprise();
        $entreprise->nom=$t_values[0]; //nom
        $entreprise->activite=$t_values[2]; 
        $entreprise->ape=$t_values[3]; 
        $entreprise->metiers=$t_values[4]; 
        $entreprise->accepte_stg=1;//$t_values[5]; 
        for($j=0;$j<4;$j++) 
            if($t_values[18+$j]!="") 
                $entreprise->adresse.=(($entreprise->adresse!="")?"\r\n":"").trim($t_values[18+$j]);
        $entreprise->cp=(strlen($t_values[22])<=5)?$t_values[22]:"";
        $entreprise->ville=$t_values[23]; 
        $entreprise->pays=$t_values[25]; 
        $entreprise->tel_fixe=$t_values[26]; 
        $entreprise->tel_mobile=$t_values[27]; 
        $entreprise->email=$t_values[29]; 
        $entreprise->site_web=$t_values[30]; 
        $entreprise->ursaff=$t_values[32]; 
        $entreprise->assurance_nom=$t_values[33]; 
        $entreprise->assurance_ref=$t_values[34]; 
        $entreprise->ridet=$t_values[31]; 
        $entreprise->observations=$t_values[31];
        $entreprise->save();

        //Création contact Responsable
        //création/recherche des niveaux
        $contact=new Contact();
        $contact->id_entreprise=$entreprise->id;
        $contact->civilite=(strlen($t_values[38])<=5)?$t_values[38]:"";
        $contact->nom=$t_values[39];
        $contact->prenom=$t_values[40];
        $contact->fonction=$t_values[41];
        $contact->tel_fixe=$t_values[42];
        $contact->tel_mobile=$t_values[44];
        $contact->email==$t_values[45];
        $contact->save();        
    }
*/

    // Importantion de svaleurs de la ligne 
    //          $sep_plus pour les elements multiples
    // 
    public function importe_ligne_enseignants($t_values,$sep_plus=",")
    {
        //FORMAT : 0=>CIVILITE / 1=>NOM / 2=>PRENOM / 3=> DISCIPLINE/ 4=>PPCLASSE / 5=>EMAIL / 6=>Mobile / 7=>TelFixe
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $t_id_classe_pp=[];
        //Multi Classes
        $classes=trim($t_values[4]);
        if($classes!="");
        $t_classes=explode($sep_plus,$classes);
        foreach( $t_classes as $nom_classe) {
            $classe=Classe::where("nom_court","like",trim($nom_classe))->first();
            if($classe) $t_id_classe_pp[]=$classe->id;
        }

        $id_etablissement=$user->id_etablissement;
        $enseignant=new Enseignant();
        $enseignant->civilite=$t_values[0]; 
        $enseignant->nom=strtoupper($t_values[1]); //nom
        $enseignant->prenom=$t_values[2]; 
        $enseignant->discipline=$t_values[3];
        $enseignant->email=$t_values[5]; 
        $enseignant->tel_mobile=$t_values[6]; 
        $enseignant->tel_fixe=$t_values[7]; 
        $enseignant->id_etablissement=$id_etablissement;
        dd($enseignant);
        $enseignant->save();
        if($classe) {
            foreach( $t_id_classe_pp as $id_classe) {
                $classe=Classe::find($id_classe);
                $classe->id_pp=$enseignant->id;
                $classe->save();
            }
        }
    }

    public function importe_ligne_responsables($t_values)
    {
        //FORMAT : 0=>CIVILITE / 1=>NOM / 2=>PRENOM / 3=>ADRESSE / 5=>CP 
        // 6=>VILLE / 8=>PAYS
       //  10=>TelFixe / 12=>Mobile / 13=> TelBureau / 14=>Email
        // 14 => IDConnexion / 19=>Destinaire Info

        //création/recherche des niveaux
        $nom_classe=$t_values[3];
        $classe=Classe::where("nom","=",$nom_classe)->first();
        $responsable=new Responsable();
        $responsable->civilite=$t_values[0];
        $responsable->nom=strtoupper($t_values[1]); //nom
        $responsable->prenom=$t_values[2]; 
        $responsable->adresse=$t_values[3];
        if($t_values[4]!="")  $responsable->adresse.=(($t_values[3]!="")?"\r\n":"").$t_values[4];
        $responsable->cp=$t_values[5]; 
        $responsable->ville=$t_values[6]; 
        $responsable->pays=$t_values[8]; 
        $responsable->tel_fixe=$t_values[10]; 
        $responsable->tel_mobile=$t_values[12]; 
        $responsable->tel_bureau=$t_values[13]; 
        $responsable->email=$t_values[14]; 
        $responsable->id_connexion=strtolower(substr($responsable->prenom,0,1).$this->enleveaccents($t_values[1]));
        $responsable->pwd_connexion=Hash::make(Str::random(12));
        $responsable->destinataire_info=(strtoupper($t_values[19])=="OUI")?"O":"N"; 
        if($classe) $ensresponsableignant->id_classe_pp=$classe->id;
        //if($t_values[14]=="JU9VGZPMQWYSXF8E") dd($responsable);
        $responsable->save();
    }


    public function importe_ligne_maitres_de_stage($t_values)
    {
        /*FORMAT : 0=>Civilite 1=>NOM /2=>Prénom,3=>Fonction,4=>Email 
        /=>Fixe,44=>Postable,45=>Email,
        */


        //$t_cols=["nom"=>0,"prenom"=>1,"date_naissance"=>2,"sexe"=>3,"classe"=>4];

        //$t_values=explode($sep,$line);
        $entreprise=new Entreprise();
        $entreprise->nom=$t_values[0]; //nom
        $entreprise->activite=$t_values[2]; 
        $entreprise->ape=$t_values[3]; 
        $entreprise->metiers=$t_values[4]; 
        $entreprise->accepte_stg=1;//$t_values[5]; 
        for($j=0;$j<4;$j++) 
            if($t_values[18+$j]!="") 
                $entreprise->adresse.=(($entreprise->adresse!="")?"\r\n":"").trim($t_values[18+$j]);
        $entreprise->cp=(strlen($t_values[22])<=5)?$t_values[22]:"";
        $entreprise->ville=$t_values[23]; 
        $entreprise->pays=$t_values[25]; 
        $entreprise->tel_fixe=$t_values[26]; 
        $entreprise->tel_mobile=$t_values[27]; 
        $entreprise->email=$t_values[29]; 
        $entreprise->site_web=$t_values[30]; 
        $entreprise->ursaff=$t_values[32]; 
        $entreprise->assurance_nom=$t_values[33]; 
        $entreprise->assurance_ref=$t_values[34]; 
        $entreprise->ridet=$t_values[31]; 
        $entreprise->observations=$t_values[31];
        $entreprise->save();

        //Création contact Responsable
        //création/recherche des niveaux
        $contact=new Contact();
        $contact->id_entreprise=$entreprise->id;
        $contact->civilite=(strlen($t_values[38])<=5)?$t_values[38]:"";
        $contact->nom=$t_values[39];
        $contact->prenom=$t_values[40];
        $contact->fonction=$t_values[41];
        $contact->tel_fixe=$t_values[42];
        $contact->tel_mobile=$t_values[44];
        $contact->email==$t_values[45];
        $contact->save();        
    }


  private function  enleveaccents($str)
        {
          $url = $str;
            $url = preg_replace('#Ç#', 'C', $url);
            $url = preg_replace('#ç#', 'c', $url);
            $url = preg_replace('#è|é|ê|ë#', 'e', $url);
            $url = preg_replace('#È|É|Ê|Ë#', 'E', $url);
            $url = preg_replace('#à|á|â|ã|ä|å#', 'a', $url);
            $url = preg_replace('#@|À|Á|Â|Ã|Ä|Å#', 'A', $url);
            $url = preg_replace('#ì|í|î|ï#', 'i', $url);
            $url = preg_replace('#Ì|Í|Î|Ï#', 'I', $url);
            $url = preg_replace('#ð|ò|ó|ô|õ|ö#', 'o', $url);
            $url = preg_replace('#Ò|Ó|Ô|Õ|Ö#', 'O', $url);
            $url = preg_replace('#ù|ú|û|ü#', 'u', $url);
            $url = preg_replace('#Ù|Ú|Û|Ü#', 'U', $url);
            $url = preg_replace('#ý|ÿ#', 'y', $url);
            $url = preg_replace('#Ý#', 'Y', $url);
         return $url;
        } 
}


