<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Permission2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use DB;
use App\Http\Requests\PermissionRequest;
use App\Http\Requests\RoleChangeRequest;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionsController extends Controller {
 
    private $menu='acces';
    private $submenu='permissions';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) return Redirect::route('home');

        $permissions = Permission2::where('id', '<>', 'null')->orderBy('name')->get();

        return View::make('acces.permissions.index', [
            'permissions' => $permissions, 
            'user'=>$user,
            'menu' => $this->menu,'submenu' => $this->submenu
        ]);
    }
 
    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter permissions")) return Redirect::route('home');

        $mode="create";
        return View::make('acces.permissions.create',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu, "mode"=>$mode,
            ]);

    }
 
    public function store(PermissionRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter permissions")) return Redirect::route('home');

        $permission = $this->setData($request);
        $msg="La permission ".$permission->nom." a été créée";
        Session::flash('success', $msg); 
        return Redirect::to('/permissions');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier permissions")) return Redirect::route('home');

        $permission = Permission::find($id);
        return View::make('acces.permissions.'.$mode, 
            [ 
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu, "mode"=>$mode,
                'permission' => $permission
            ]);
    }
 
    public function update($id,PermissionRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier permissions")) return Redirect::route('home');

        $permission = $this->setData($request,$id);
        $msg="La permission ".$permission->nom." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/permissions');
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter permissions")) return Redirect::route('home');
        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) return Redirect::route('home');
        
        $permission=Permission::find($id);
        $nom=$permission->name;
        DB::table('role_has_permissions')->where('permission_id', '=', $id)->delete();
        DB::table('model_has_permissions')->where('permission_id', '=', $id)->delete();
        DB::table('permissions')->where('id', '=', $id)->delete();
        Permission::destroy($id);
 
        $msg="La Permission ".$nom." a été supprimée";
        return Redirect::to('/permissions')->with('success', $msg); 
    }
 
    public function setData($request,$id="")
    {
        if($id=="") $permission =  new Permission;
        else $permission = Permission::find($id);

        $permission->name = $request->name;
        $permission->save();

        return $permission;
    }
}



