<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class EtablissementRequest extends FormRequest {
    public function rules() {
        return [
            'nom' => 'required|max:100',
            'adresse' => '',
            'rne' => 'required|max:8',
            'id_commune' => '',
            'tel' => 'max:6',
            'cafat' => 'max:50',
            'assurance_nom' => 'max:50',
            'assurance_ref' => 'max:50',
            'email' => 'email|max:50',
            'representant_nom' => '',
            'representant_fonction' => '',
        ];
    }



     public function attributes() {
        return [
            'nom' => 'Nom',
            'rne' => "Numéro de l'établissement(RNE)",
            'adresse' => 'Adresse',
            'id_commune' => 'Commune',
            'tel' => 'Téléphone',
            'cafat' => 'Numéro CAFAT',
            'assurance_nom' => "Nom de l'assureur",
            'assurance_ref' => "Référence de l'assureur",
            'email' => 'Email',
            'representant_nom' => 'Nom du représentant',
            'representant_fonction' => 'Fonction du représentant',
        ];
    }


    public function authorize() {
        return true;
    }
}