<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class OffreRequest extends FormRequest {
    public function rules() {
        return [
            'date_deb' => 'required',
            'date_fin' => 'required',
            'id_niveau' => 'required',
            'id_filiere' => 'required',
            'id_categorie' => 'required',
            'description' => 'required',
            'lieu' => 'required',
            'contact' => 'required',
            'tel' => '',
            'email' => 'required',
            'nb_jours' => 'required',
            'remunere' => '',
            'heberge' => '',
            'statut' => '',
            'horaires' => '',
            'nbheures' => '',

        ];
    }
 
     public function attributes() {
        return [
            'date_deb' => 'Date de début',
            'date_fin' => 'Date de fin',
            'id_niveau' => 'Niveau scolaire demandé',
            'id_filiere' => 'Filière souhaitée',
            'id_categorie' => 'Domaine du sujet proposé',
            'description' => 'Description',
            'lieu' => 'Lieu',
            'contact' => 'Contact',
            'tel' => 'Téléphone',
            'email' => 'Email',
            'nb_jours' => 'Nombre de jours (<i>onglet [Horaires]</i>)',
            'remunere' => 'Remunéré',
            'heberge' => 'Hebergé',
            'statut' => 'Statut',
            'horaires' => 'Horaires',
            'nbheures' => "Le nombre d'heures doit être compris entre 30 et 40h  (<i>onglet [Horaires]</i>)",
        ];
    }


    public function authorize() {
        return true;
    }
}