<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class SessionStageRequest extends FormRequest {
    public function rules() {
        return [
            'id_classe' => 'required',
            'groupe' => '',
            'id_type_stage' => 'required',
            'id_prof' => '',
            'color' => 'max:7',
            'nom' => 'required|max:100',
            'date_deb' => 'required|date_format:d/m/Y',
            'date_fin' => 'required|date_format:d/m/Y|after:date_deb',
        ];
    }
 

     public function attributes() {
        return [
            'id_classe' => 'Classe',
            'groupe' => 'Groupe',
            'id_type_stage' => 'Type de stage',
            'nom' => 'Nom',
            'date_deb' => 'Date de début',
            'date_fin' => 'Date de fin',
            'id_prof' => 'Professeur référent',
            'color' => 'Couleur',

        ];
    }


    public function authorize() {
        return true;
    }
}