<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class StageRequest extends FormRequest {
    public function rules() {
        return [
            'id_eleve' => 'required',
            'id_entreprise' => 'required',
            'sujet' => '',
            'date_deb' => 'required',
            'date_fin' => 'required',
            'id_categorie' => 'required',
            'responsable_ent' => '',
            'responsable_prof' => '',
            'horaires' => '',
            'nbheures' => 'min:30|max:40',
            'remunere' => '',
            'heberge' => '',
            'conv_ent' => '',
            'conv_eleve' => '',
            'doc_attest'=>'',
            'doc_cr_ent'=>'',
            'doc_cr_prof'=>'',
            'doc_rapport'=>'',
            'type_stage'=>'',
            'statut'=>'',
        ];
    }
 

     public function attributes() {
        return [
            'id_eleve' => 'Elève',
            'id_entreprise' => 'Entreprise',
            'id_categorie' => 'Catégorie',
            'date_deb' => 'Date de début',
            'date_fin' => 'Date de fin',
            'statut'=>'Statut',
            'horaires' => 'Horaires',
            'nbheures' => "Le nombre d'heures doit être compris entre 30 et 40h",

        ];
    }


    public function authorize() {
        return true;
    }
}