@extends('layouts.dash')

@section('title') Filières @stop
@section('title_card',"Filières")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <label>Catégorie</label>
                    {!! html()->select('select_id_categorie')->options($categories)->value(($categorie)?$categorie->id:'')
                        ->placeholder('Choisir une catégorie')
                        ->attributes(['id'=>'select_id_categorie','class' => 'form-control','onchange'=>'select_filtre()']) 
                    !!} 
                </div>
            </div>

            <script>
                function select_filtre() {
                    var select_id_categorie = document.getElementById('select_id_categorie');
                    var select_id_categorie = [...select_id_categorie.selectedOptions].map(option => option.value);
                    var url="" ; 
                    if(select_id_categorie=="") select_id_categorie=0;
                    url="{!! url('filieres_list/') !!}/"+select_id_categorie;
                    location.href=url;
                }
            </script>
        </div>
        @if($categorie)
            <div class="card-body">
                <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                    <thead>
                        <tr>
                            <th>Nom</th>
                            <th width='10%'>Nombre de&nbsp;classes</th>
                            <th width='10%'>Nombre d'élèves</th>
                            <th width='10%'>Nombre de&nbsp;stagiaires</th>
                            <th width='1px'>
                                @if($user->can("ajouter filieres") || $user->hasRole("ADMINISTRATEUR"))
                                <a href="{!! url('filieres/create') !!}" 
                                    class="btn btn-success btn-sm">
                                    <span class='fa fa-plus'></span> Ajouter une filière
                                </a>  
                                @endif
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($filieres as $filiere)
                        <tr class=''>
                            <td nowrap>
                                <a href="{!! url('/filieres/'.$filiere->id) !!}">{!! $filiere->nom !!}</a>
                            </td>
                            <td align="center">{!! $filiere->nb_classes !!}</td>
                            <td align="center">{!! $filiere->NbEleves !!}</td>
                            <td align="center">{!! $filiere->nb_stagiaires !!}</td>
                            <td align="left" >
                                @if($filiere->CanDelete)
                                    {{ html()->form('DELETE', url('/filieres/'. $filiere->id))->open() }}   
                                    {{ csrf_field() }}
                                @endif
                                <a title="Consulter" href="{!! url('/filieres/'.$filiere->id) !!}" class="btn btn-info btn-sm">
                                    <span class='fa fa-eye'></span>
                                </a> 
                                @if($filiere->CanDelete)
                                    <button  title="Supprimer" class="btn btn-danger btn-sm"><span class='fa fa-trash'></span></button>
                                    {{ html()->form()->close() }}
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
</div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable")
@endsection
