@extends('layouts.dash')

@section('title') Enseignants @stop
@section('title_card',"Enseignants")
@section('subtitle_card',"Liste")

@section('content')
<div class="card">
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">

                </div>
            </div>

            <table class="table table-striped table-bordered">
                <tr>
                    <th>Données</th>
                    <th>Date de la dernière importation</th>
                    <th>Nb Lignes importées</th>
                    <th>Etat de l'importation</th>
                    <th></th>
                </tr>
                
                @foreach($t_tables as $table)
                    <?php
                        $msg="";
                        $class="";$style="";
                        $result_import=false;
                        if(isset($t_msg[$table]) && ($t_msg[$table]!="") ) {
                            $result_import=true;
                            $class='';
                            $style="background-color:lightgreen;font-family:courier;font-weight:bold";
                        }
                    ?>
                    <tr>
                        <td style="font-weight:bold">{!! strtoupper($table) !!}</td>
                        <td align="center">{!! isset($t_info[$table]["date"])?$t_info[$table]["date"]:"-" !!} </td>
                        <td align="center">{!! isset($t_info[$table]["nb_lignes"])?$t_info[$table]["nb_lignes"]:"-" !!}</td>
                        <td align="center" style="font-size:30px;">
                            @if(isset($t_info[$table]["statut"]))
                                <span 
                                style='{!! ($t_info[$table]["statut"]=="OK")?"color:green":"color:red" !!}'
                                class='fa {!! ($t_info[$table]["statut"]=="OK")?"fa-thumbs-o-up":"fa-thumbs-o-down" !!}'></span>  
                            @else
                                <span>-</span>        
                            @endif
                        </td>
                        <td>
                            @if(!$result_import)

                                <a id="tabletoimport" href="{!! url('importations_pop/'.$table) !!}" 
                                      class="btn btn-primary btn-sm pop_import fancybox.iframe">Télécharger un fichier .csv</a>

                             @endif
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
</div>
@endsection


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts')
    <!-- FancyBox -->
    <script src="{{ url('js/jquery.fancybox.js') }}"></script> 
    <script>
    $(".pop_import").fancybox({
        fitToView   : false,
        autoDimensions:true,
        autoSize    : true,
        scrolling : false,
        //width       : '80%',
        //height      : '80%',
        closeClick  : true,
        openEffect  : 'fade',
        closeEffect : 'fade',
        afterClose: function () {
            parent.location.reload();
        }
           
    });
  </script>
@endsection
