<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', 'App\Http\Controllers\HomeController@index')->name('home');


/* OUTILS */
Route::get('/closepop', 'App\Http\Controllers\HomeController@closepop');


/* ************* STRUCTURES ************** */


//Etablissements
Route::get('/etablissements', 'App\Http\Controllers\EtablissementsController@index_lycee');
Route::get('/etablissements/lycees', 'App\Http\Controllers\EtablissementsController@index_lycee');
Route::get('/etablissements/colleges', 'App\Http\Controllers\EtablissementsController@index_college');

//Secteurs
Route::get('/secteurs', 'App\Http\Controllers\SecteursController@index');
Route::get('/soussecteurs', 'App\Http\Controllers\SoussecteursController@index');

//Niveaux
Route::get('/niveaux', 'App\Http\Controllers\NiveauxController@index');


//Filières
Route::resource('/filieres', 'App\Http\Controllers\FilieresController');
Route::get('/filieres_list/{id_categorie}', 'App\Http\Controllers\FilieresController@index_filtre');
Route::resource('/filieres_categories', 'App\Http\Controllers\FilieresCategoriesController');

//Diplomes
Route::resource('/diplomes', 'App\Http\Controllers\DiplomesController');



//Elèves
Route::resource('/eleves', 'App\Http\Controllers\ElevesController');
Route::get('/eleves_list/{id_classe}', 'App\Http\Controllers\ElevesController@index_filtre');

//Sessions
Route::resource('/sessions', 'App\Http\Controllers\SessionsController');
Route::get('/sessions_list/{id}', 'App\Http\Controllers\SessionsController@index');
Route::get('/sessions_calendar', 'App\Http\Controllers\SessionsController@index_calendar');
Route::get('/sessions_create/{id_classe}/{groupe}/{semaine?}', 'App\Http\Controllers\SessionsController@create_pop');
Route::get('/sessions_show/{id_session}', 'App\Http\Controllers\SessionsController@show_pop');
Route::get('/sessions_edit/{id_session}', 'App\Http\Controllers\SessionsController@edit_pop');
Route::get('/sessions_delete/{id_session}', 'App\Http\Controllers\SessionsController@destroy_pop');
Route::delete('/sessions/{id_session}', 'App\Http\Controllers\SessionsController@destroy_pop');

//USERS ROLES PERMISSIONS
Route::resource('users', 'App\Http\Controllers\UsersController');
Route::resource('roles', 'App\Http\Controllers\RolesController');
Route::resource('permissions', 'App\Http\Controllers\PermissionsController');

Route::get('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@newprofil'));
Route::put('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@changeprofil'));



//importations
Route::get('/importations', 'App\Http\Controllers\ImportationsController@index');
Route::get('/importations_pop/{table}', 'App\Http\Controllers\ImportationsController@import_csv_pop');
//Route::PUT('/importations_pop','App\Http\Controllers\ImportationsController@import_csv');
Route::POST('/importations_pop','App\Http\Controllers\ImportationsController@import_csv');

Route::get('/import_siecle/{id?}', 'App\Http\Controllers\ImportationsController@index_siecle');
Route::post('/importations', 'App\Http\Controllers\ImportationsController@importe');
Route::post('/importXML_valide', 'App\Http\Controllers\ImportationsController@xml_importe_validation');