<?php namespace App\Models;

use App\Models\Sipre\SipreBeneficiaire;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use Illuminate\Support\Facades\Auth;

class Allocataire extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'allocataires';



  public function enfants()
    {
        return $this->hasMany('Enfant','parents1','benjum');
    }

    public function enfants_conjoint()
    {
        return $this->hasMany('Enfant','parents2','benjum');
    }


    /* Dates */
    public function getDates()
    {
        return array('date_naissance','date_deces','date_pi','updated_at','created_at');
    }


    public function getDateNaissanceAttribute($value)
    {
        return ($this->attributes['date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['date_naissance'])):null;
    }

    public function getDateDecesAttribute($value)
    {
        return ($this->attributes['date_deces']!=null)?date('d/m/Y', strtotime($this->attributes['date_deces'])):null;
    }

    public function getDatePiAttribute($value)
    {
        return (($this->attributes['date_pi']!=null))?date('d/m/Y', strtotime($this->attributes['date_pi'])):null;
    }

    public function getUpdatedAtAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['updated_at'])):null;
    }

    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }
    public function getCreatedAtDayAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/y', strtotime($this->attributes['created_at'])):null;
    }


    /***************/
    /* NOM ADRESSE */
    /***************/
    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }
    public function getIdCPSWFPADAttribute()
    {
        return str_pad($this->id_cpswf, 5, "0", STR_PAD_LEFT);
    }

    
    /* ADRESSE */
    public function getVillageFullNameAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        return $village->FullName;
    }

    public function getIleAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        $district=District::find($village->id_district);
        if(!$district) return "";
        return $district->ile;
    }

    public function getAdresseCompleteAttribute()
    {
        $sep="<br/>";
        $adresse=trim($this->adresse);
        if($this->id_village) $adresse.=$sep.$this->VillageFullName;

        return trim($adresse);
    }


    /***************/
    /* NOM         */
    /***************/
    /* NOM+PRENOM  */
    public function getNomCompletAttribute()
    {
        $lib=$this->nom." ".$this->prenom;
        if($this->nom_naissance) $lib.=" Né".(($this->sexe=="M")?" ":"e ").$this->nom_naissance;
        return $lib;
    }

    public function getNomComplet2Attribute()
    {
            return $this->nom." ".$this->prenom.(($this->nom_naissance)?" - Né".(($this->sexe=="M")?" ":"e ").$this->nom_naissance:"");
    }

    /* NOM seul pour éditions */
    public function getNomReduit($taille_max=20)
    {
        $nom=trim($this->nom);
        if(strlen($nom)>$taillemax) $nom=substr($nom,0,$taillemax);
        return trim($nom);
    }

    /* NOM+PRENOM pour éditions */
    public function getNomCompletReduit($taille_max=20)
    {
        $t_prenom=explode(' ',$this->prenom);
        $prenom=trim($t_prenom[0]);
        if(strlen($prenom)>$taillemax) $prenom=substr($prenom,0,$taillemax);
        return trim($this->nom)." ".$prenom;
    }

    /* NOM+PRENOM (1er lettre si > taille) pour éditions */
    public function getNomPrenomReduit($taillemax=30)
    {
        $nom=trim($this->nom);
        if(strlen($nom)>$taillemax) $nom=substr($nom,0,$taillemax);
        $t_prenom=explode(' ',trim($this->prenom));
        $prenom=trim($t_prenom[0]);
        if(strlen($nom." ".$prenom)>$taillemax) $prenom=substr($prenom,0,1).".";

        return trim($nom." ".$prenom);
    }


    /***************/
    /* AGE         */
    /***************/
    public function getAgeAttribute()
    {
        $date=$this->attributes['date_naissance'];
        $age= (int) ((time() - strtotime($date)) / 3600 / 24 / 365);

        return $age;
    }


    /***************/
    /* PARTENAIRE  */
    /***************/
    /* Retourne l'id du partanaire, conjoiunt ou titulaire */
    public function getIdPartenaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        if($this->IsTitulaire) return $famille->id_conjoint;
        return $famille->id_titulaire;
    }

    public function getIdPADPartenaireAttribute()
    {
        return str_pad($this->IdPartenaire, 5, "0", STR_PAD_LEFT);
    }

    /* Retourne l'id du partanaire, conjoiunt ou titulaire */
    public function getPartenaire()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        $id_partenaire=($famille->id_conjoint!=$this->id)?$famille->id_conjoint:$famille->id_titulaire;
        $partenaire=Allocataire::find($id_partenaire);
        return $partenaire;
    }

    /***************/
    /* FAMILLE      */
    /***************/
    public function getEnfantLienParenteAttribute()
    {
        $famille_enfant=FamilleEnfant::where("id_famille","=",$this->id_famille)->where("id_enfant","=",$this->id)->first();
        if(!$famille_enfant) return "";
        if(!isset(MyApp::FOYER_ROLES[$famille_enfant->lien_parente])) return "";

        return MyApp::FOYER_ROLES[$famille_enfant->lien_parente];
    }

    public function setFamille($id_famille)
    {
        $this->id_famille = $id_famille;
        $this->save();
        return $this->save();
    }

    public function getFamille()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return []; 
        return $famille;
    }

    public function getIdPADFamilleAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        return $famille->IdPAD;
    }

    /* TITULAIRE */
    public function getIsTitulaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return false; 
        if($famille->id_titulaire==$this->id) return true;
        return false;
    }
    public function getFamilleIdTitulaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        return $famille->id_titulaire;
    }

    public function getNomCompletTitulaireAttribute()
    {
        $titulaire=Allocataire::find($this->id_titulaire);
        if(!$titulaire) return "";
        return  $titulaire->NomComplet;
    }

    /* CONJOINT */
    public function getIsConjointAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return false; 
        if($famille->id_conjoint==$this->id) return true;
        return false;
    }

    public function getFamilleIdConjointAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        if($famille->id_conjoint==$this->id) return $famille->id_titulaire;
        return $famille->id_conjoint;
    }

    /*
    public function getFamilleNomConjointAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        return $famille->getParents(",");
    }
        */

    public function getNomCompletConjointAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return "";
        $conjoint=$famille->getConjoint();
        if(!$conjoint) return "";
        return  $conjoint->NomComplet;
    }

    public function getStatutParentAttribute()
    {
        if($this->sexe=="M") return "Père";
        if($this->sexe=="F") return "Mère";
        return "";
    }


    /***************/
    /* Parents     */
    /***************/
    public function getNomCompletParent1Attribute()
    {
        $parent=Allocataire::find($this->id_parent1);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }
    public function getNomCompletParent2Attribute()
    {
        $parent=Allocataire::find($this->id_parent2);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }



   /***************/
    /* Dossier     */
    /***************/
    public function getStatutDossierLibelleAttribute()
    {
      $lib=MyApp::getZBaseLibelle("BEN_STATUT_DOSSIER",$this->statut_dossier,'');

      return $lib;
    }
    public function getStatutDossierLibelleCourtAttribute()
    {
      $lib=MyApp::getZBaseLibelle($nom,$this->statut_dossier,'court');
      return $lib;
    }

    public function getInfoAides($sep="<br/>")
    {
      $lib="";
      //Aide à l'enfant
      $lib.=(($lib!="")?$sep:"").$this->getInfoDetailAides();
      $lib.=(($lib!="")?$sep:"")."Date Naissance : <b>".$this->DateNaissance.(($this->certificat==9)?"-":" - ".$this->Age." ans")."</b>";
      if($this->sexe) $lib.=$sep."Sexe : <b>".MyApp::SEXE[$this->sexe]."</b>";
      if($this->id_CPSWF) $lib.=$sep."CPSWF : <b>".$this->id_CPSWF."</b>";
      if($this->certificat_enfant) $lib.=$sep."Cert.: <b>".$this->CertificatEnfantLibelle."</b>";
      if($this->id_CPSWF) $lib.=$sep."Statut : <b>".$this->id_CPSWF."</b>";
      if($this->EnfantLienParente)  $lib.=$sep."Lien de parenté : <b>".$this->EnfantLienParente."</b>";
      

      return $lib;
    }

    public function getInfoDetailAides($card=true,$sep="<br/>")
    {
        $lib="";
        //Aide à l'enfant
        if(array_key_exists($this->types_aides,MyApp::TYPES_AIDES))  $lib=MyApp::TYPES_AIDES[$this->types_aides];
        if($lib && $card)  $lib="<span class='right badge badge-".MyApp::COLOR_AIDES[$this->types_aides]."'>".$lib."</span>";

        return $lib;
    }
    


    //Retourne si vrai si l'allocataire bénéficie de l'aide
    public function hasAide($type_aide)
    {
        $t_aides=explode(",",$this->types_aides);
        if(in_array($type_aide,$t_aides))  return true;
        return false;
    }

    /***************/
    /* ENFANTS     */
    /***************/
    public function getEnfants()
    {
        $enfants=Allocataire::where('id_parent1',"=",$this->id)->orWhere('id_parent2',"=",$this->id)->get();
        return $enfants;
    }

    public function getNbEnfantsAttribute()
    {
        $nb=DB::table('familles_enfants')->where('id_famille', '=', $this->id_famille)->count();
        $nb+=DB::table('allocataires')->where('id_parent2', '=', $this->id)->count();
        return $nb;
    }

    public function getNbEnfants($date)
    {
      $nb=DB::table('allocataires')->where("date_naissance","<",$date)->where("id_parent1","=",$this->id)->count();
      $nb+=DB::table('allocataires')->where("date_naissance","<",$date)->where("id_parent2","=",$this->id)->count();
      return $nb;
    }

    public function getCertificatEnfantLibelleAttribute()
    {
        $liste_certificats=MyApp::getZBase("CERT_ENFANTS");

        if(!isset($liste_certificats[$this->certificat_enfant])) return "";
        return$liste_certificats[$this->certificat_enfant];
    }
    
    /**
     * Nombre d'enfants pour Aide Sociale
     */
    public function getNbEnfantsAAEAttribute()
    {
        $certif_aae=MyApp::CERT_AIDE_ENFANT;
        $nb_enfants=Allocataire::where('id_parent1',"=",$this->id)->whereIn('certificat_enfant',$certif_aae)->count();
        $nb_enfants+=Allocataire::where('id_parent2',"=",$this->id)->whereIn('certificat_enfant',$certif_aae)->count();
        return $nb_enfants;
    }

    /**
     * enfants avec AAE
     */
    public function  getEnfantsAAE()
    {
        $certif_aae=MyApp::CERT_AIDE_ENFANT;;
        $enfants1=Allocataire::where('id_parent1',"=",$this->id)->whereIn('certificat_enfant',$certif_aae)->get();
        $enfants2=Allocataire::where('id_parent2',"=",$this->id)->whereIn('certificat_enfant',$certif_aae)->get();
        $enfants = $enfants1->union($enfants2);
        return $enfants;
    }

    /**
     * Calcul AAE
     */
    public function  getCalculAAEAttribute()
    {
        $nb_enfants=$this->NbEnfantsAAE;
        $base=MyApp::getParam('CAL_MONTANT_SOC');
        $t_base=explode(";",$base);
        $indemnite_nbenfant=0;
        $indemnite_montant=0;
        $montant_c=0;
        $t=array();
        for($i=1;$i<=20;$i++) { //Nb enfant max 20
            if(isset($t_base[$i-1])&&($t_base[$i-1]!="")) {
                $t_indemnite=$t_base[$i-1];
                $indemnite=explode("=",$t_indemnite);
                $indemnite_nbenfant=$indemnite[0];
                $indemnite_montant=$indemnite[1];
            }
            $t[$i]=$indemnite_montant;
        }
        $t_base=$t;
        for($i=1;$i<=$nb_enfants;$i++) {
            $indemnite_montant=$t_base[$i];
            $montant_c+=$indemnite_montant;
        }

        return $montant_c;
    }
    



    /**
     * enfants de la famille
     */
    public function  getEnfantsListe($sep="<br/>")
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return "";   
        $txt="";
		$enfants=FamilleEnfant::where('id_famille','=',$this->id_famille )->get();
		foreach($enfants as $enfant) {

            $certif=$enfant->Certificat;
            if(in_array($certif,MyApp::CERT_AIDE_ENFANT))  $certif="<span class='right badge badge-".MyApp::COLOR_AIDES["AAE"]."'>".$certif."</span>";
            else $certif="<span class='right badge badge-secondary'>".$certif."</span>";
            //$det=$enfant->getInfoDetailAides();
			$txt.=(($txt)?$sep:"").$enfant->NomComplet."&nbsp;".$enfant->Age."a".($certif?"&nbsp;".$certif:")");
		}
        return $txt;
    }

    /***************/
    /* MEMBRES    */
    /***************/
    public function getMembres()
    {
        if(!$this->id_famille) return [];
        $famille=Famille::find($this->id_famille);
        if(!$famille)  return [];
        $membres=FamilleMembre::where('id_famille',"=",$this->id)->get();
        return $membres;
    }

  /**
   * Fiche Supprimable ?
   */
  public function canIsSupprimableAttribute()
  {
    if(!($user=Auth::user())) return Redirect::route( 'login' );
    if (!$user->can("BEN_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;

    return false;
  }



    /* ******************** */
    /* RETRAITE             */
    /* ******************** */
    public function getSipreBeneficiaire()
    {
        if(!$this->id_cpswf) return "";
        $beneficiaire=SipreBeneficiaire::find($this->id_cpswf);
        if(!$beneficiaire) return "";
        return $beneficiaire;
    }
    //Montant retraire
    public function getMontantRetraiteCPSWFAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->ret_montant;
    }
    //Montant retraire
    public function getUpdatedAtCPSWFAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->UpdatedAt;
    }

  

    /***********/
    /* BANQUES */
    /***********/
    public function getCompteAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return "";
        $RIB=$allocataire_compte->IBAN_pays.' '.$allocataire_compte->IBAN_cle.' '.$allocataire_compte->IBAN_banque.' '.$allocataire_compte->IBAN_guichet.' '.
        $allocataire_compte->IBAN_compte.' '.$allocataire_compte->IBAN_clerib;

        return $RIB;
    }

    public function getBanqueIdAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return "";
        return $allocataire_compte->banque_id;
    }

    public function getNomBanqueAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        $banque=Banque::find($allocataire_compte->id_banque);
        if(!$banque) return "";
        return $banque->nom;
    }

    public function getNomTitulaireCompteAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return "";
        return $allocataire_compte->titulaire;
    }
    
    public function getLastCompte()
    {
    $allocataire_compte=AllocataireCompte::where("id_allocataire","=",$this->id)
          ->where("actif","=","1")->orderby("id","DESC")->first();
          if(!$allocataire_compte) return "";
          return $allocataire_compte;
    }
    public function getIBANcompletAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        $IBAN_pays=($allocataire_compte->IBAN_pays)?$allocataire_compte->IBAN_pays:"";
        $IBAN_cle=($allocataire_compte->IBAN_cle)?$allocataire_compte->IBAN_cle:"";

        return $IBAN_pays.$IBAN_cle.$allocataire_compte->RIBcomplet;
    }

    public function getRIBcompletAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        $IBAN_banque=($allocataire_compte->IBAN_banque)?$allocataire_compte->IBAN_banque:"";
        $IBAN_guichet=($allocataire_compte->IBAN_guichet)?$allocataire_compte->IBAN_guichet:"";
        $IBAN_compte=($allocataire_compte->IBAN_compte)?$allocataire_compte->IBAN_compte:"";
        $IBAN_clerib=($allocataire_compte->IBAN_clerib)?$allocataire_compte->IBAN_clerib:"";
        return $IBAN_banque.$IBAN_guichet.$IBAN_compte.$IBAN_clerib;
    }

    public function getIBAN_paysAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        return $IBAN_pays;
    }




  

    /* ******************** */
    /* LOG                  */
    /* ******************** */
    public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value;
        }
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
      }
  }
