<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

use App\Models\Allocataire;
use App\Models\AllocataireEnfant;
use App\Models\User;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\EnfantRequest;
use Request;
use Response;
use App\Models\Parametre;
use App\Http\Controllers\Logs;


class AllocatairesEnfantsController extends Controller {

    private $menu='allocataires';
    private $submenu='enfants';
    private $menu_home="aides";


    public function index()
    {

    }

    public function create($allocataire_id,$mode="create",$mode_frame=false) {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(($mode=="create") && !$user->can("ALO_MAJ")) return redirect('home');

        $page=($mode_frame)?$mode."_pop":$mode;
        $allocataire=Allocataire::find($allocataire_id);
        return View::make('tiers.enfants.'.$page, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'mode' => $mode,
            'allocataire' => $allocataire
        ]);
    }

    public function create_pop($allocataire_id,$mode="create") {
        return $this->create($allocataire_id,$mode="create",true);
    }

    public function store(EnfantRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_AJO")) return redirect('home');

        $enfant = $this->setData($request);
        $type=$request->type_aff;

        Session::put("onglet_allocataire","o_famille");
        $msg="<blockquote><h2>La fiche de l'enfant <strong>".$enfant->NomComplet."</strong> a été ajoutée.</h2></blockquote>";
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function edit($id,$allocataire_id="",$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        $form_mode=false;
        $allocataire="";
        $enfant=Enfant::find($id);
        if($allocataire_id) {$allocataire=Allocataire::find($allocataire_id);$form_mode=true;}

        return View::make('tiers.enfants.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'form_mode' => $form_mode,
            'mode' => $mode,
            'allocataire' => $allocataire,
            'enfant' => $enfant, 
        ]);
    }

    public function update($id,EnfantRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        $enfant = $this->setData($request,$id);
        $type=$request->type_aff;

        Session::put("onglet_allocataire","o_famille");
        $msg="<blockquote><h2>La fiche de l'enfant <strong>".$enfant->NomComplet."</strong> a été modifiée.</h2></blockquote>";
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function show($id,$id_allocataire="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_VISU")) return redirect('home');
        
        return $this->edit($id,$id_allocataire,"show");
    }

    public function destroy($id_enfant,$id_parent,$type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_SUP")) return redirect('home');

        $allocataires_enfants=AllocataireEnfant::where('id_parent1','=',$id_parent)->orWhere('id_parent2','=',$id_parent)->get();
        foreach($allocataires_enfants as $allocataire_enfant) {
            if(($allocataire_enfant->id_parent1==$id_parent) || ($allocataire_enfant->id_parent2==$id_parent)) {
                if($allocataire_enfant->id==$id_enfant) $allocataire_enfant->delete();
                $msg="L'enfant "." a été enlevé do foyer ";;
            }
        }

        if($msg) Session::flash('message', $msg);
        Session::put('onglet_allocataire', "o_foyer");
        return Redirect::to('/allocataire_show/'.$id_parent."/".$type);
    }

    public function setData($request,$id="")
    {
        if($id) $enfant = Enfant::find($id);
        else $enfant = new Enfant;
        $enfant->nom  = strtoupper($request->nom);
        $enfant->prenom  = ($request->prenom);
        $enfant->sexe = $request->sexe;
        $date=$request->date_naissance;
        $enfant->date_naissance = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $enfant->certif = $request->certif;
        $enfant->parents1 = $request->id_allocataire;
        $enfant->parents2 = null;
        $enfant->obs = $request->obs;
        $enfant->save();
        return $enfant;
    }


    public function autocomplete_enfant(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select id ,CONCAT(TRIM(nom) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),')'
                ) as value from allocataires where nom like ('{$param}%') or id='{$param}%'
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }

}
