<?php 
namespace App\Http\Controllers\Api;

use Auth\AuthController;
use App\Models\MyApp;
use App\Models\Vehicule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Validator;
use View;
use DB;


class InfoPlaqueController extends ApiController {

    public function index($msg="")
    {
        return View::make('vehicules.api.api_chercher', [
            "msg" => $msg
        ]);
    }

    public function chercher(Request $request )
    {

        if($request->numero) return $this->getProprietaire($request->numero);
        if($request->nom) return $this->getVehicules($request->nom);
        $msg="Saisie incorrecte";
        Session::flash('message', $msg);

        return $this->index("Saisie incorrecte");
    }


    public function getProprietaire($numero)
    {
        
        $vehicule=Vehicule::where(DB::raw("replace(numero,' ','')"),'=',$numero)->first();
        if(!$vehicule) $vehicule="";
        $mode="numero";
        return View::make('vehicules.api.api_info', [
            'vehicule' => $vehicule, 'numero' => $numero, 'mode' => $mode
        ]);
    }


    public function getVehicules($nom)
    {
        $nom=str_replace(".","",$nom);
        $nom=str_replace(" ","%",$nom);
        $vehicules=Vehicule::
            where(DB::raw("replace(prop1_nom,'.','')"),'like',$nom."%")
            ->orwhere(DB::raw("replace(prop2_nom,'.','')"),'like',$nom."%")
            ->get();
        if(!$vehicules) $vehicules="";
        $mode="nom";

        return View::make('vehicules.api.api_info', [
            'vehicules' => $vehicules, 'nom' => $nom, 'mode' => $mode
        ]);
    }


    public function getNumero($nom)
    {
        dd($nom);
    }
}