<?php namespace App\Http\Controllers\Editions;


use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
use DB;
use App\Http\Controllers\Controller;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsVersementsController extends Controller {
    /**
     * Liste des versements
     */
    //Contribution Sociale de Retraite
    public function imprimer_csr($num_imp="") {return $this->imprimer($num_imp,"CSR"); }
    //Aide à l'enfant
    public function imprimer_aae($num_imp="") {return $this->imprimer($num_imp,"AAE"); }
    //Prime a la naissance
    public function imprimer_pan($num_imp="") {return $this->imprimer($num_imp,"PAN"); }


    public function imprimer($num_imp,$type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $num_imp_PAD=str_pad($num_imp,4, "0", STR_PAD_LEFT);
        $date=date('d/m/Y');
        $titre="";
        $titre="Versement ".MyApp::PREFIXE_AIDES[$type_aide].MyApp::TYPES_AIDES[$type_aide];
        $titre_doc=$titre;
        $nom_fichier="versements_".$type_aide."_".date("Y_m_d").$num_imp_PAD.".pdf";
        $font="Arial";
        $font_size=8;

        //Si prépa ou Final
        if($num_imp=="") {
            $titre.=" (préparation)";
            $titre_doc.=" (préparation)";
            $versements=VersementPrepa::where('type','=',$type_aide)->where('num_imp','=',$num_imp)->distinct()->orderby('id_banque')->orderby('ile','DESC')->orderby('district','DESC')
            ->orderby('destinataire_nom')->orderby('destinataire_prenom')->get();
        } else {
            $titre.=" N°".$num_imp_PAD;
            $titre_doc.=" N°".$num_imp_PAD;
            $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)->distinct()->orderby('id_banque')->orderby('ile','DESC')->orderby('district','DESC')
            ->orderby('destinataire_nom')->orderby('destinataire_prenom')->get();  
        }

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AliasNbPages();
        $fpdf->SetAutoPageBreak(false,5);
        $fpdf->AddPage();
        //Titre Service
        $h=7;$cadre="";
        $depX=5;
        //Titre
        $fpdf->SetFont($font,'',14);
        $fpdf->SetX($depX);
        $fpdf->SetFillColor(135,206,250);
        $this->Header($fpdf,$titre_doc);
        //Liste des Versements
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',$font_size);
        $w=array(10,40,30,20,20,20,60);
        $col_def=array('N°ALL.'=> $w[0],'NOM' => $w[1],'PRENOM' => $w[2],'RAPPEL' => $w[3],"MNT CFP" => $w[4],"MNT EUR" =>$w[5],"COMPTE" =>$w[6]);            
        $col_def_espece=array('N°ALL'=> $w[0],'NOM' => $w[1],'PRENOM' => $w[2],'RAPPEL' => $w[3],"MNT CFP" => $w[4],"DATE" =>$w[5],"EMARGEMENT" =>$w[6]);  
        $tot=["nb_alloc"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];
        $tot_g=["nb_alloc"=>0,"cfp"=>0,"eur"=>0,"cfp_h"=>0,"eur_h"=>0,
            "nb_10K"=>0,"nb_5K"=>0,"nb_1K"=>0,"nb_500"=>0,"nb_200"=>0, "nb_100"=>0,"nb_50"=>0,"nb_20"=>0,"nb_10"=>0,
            "nb_10K_F"=>0,"nb_5K_F"=>0,"nb_1K_F"=>0,"nb_500_F"=>0,"nb_200_F"=>0, "nb_100_F"=>0,"nb_50_F"=>0,"nb_20_F"=>0,"nb_10_F"=>0];

        $t_sstotal_type=array();$espece=false;$i=0;$banque_old="";
        $h=6;$h=$h*2;$nb_ligne=0;$nbmax_ligne=13;
        foreach($versements as $versement) {
            $nom=(strlen($versement->destinataire_nom)>21)?substr($versement->destinataire_nom,0,21):$versement->destinataire_nom;
            $prenom=(strlen($versement->destinataire_prenom)>21)?substr($versement->destinataire_prenom,0,21):$versement->destinataire_prenom;
            $titulaire=(strlen($versement->titulaire)>21)?substr($versement->titulaire,0,21):$versement->titulaire;
            $banque=$versement->BanqueNom;
            $espece=false;
            // Banque Espece
            if(!$banque) {
                if($versement->ile=="W") $banque="ESPECES WALLIS";
                if($versement->ile=="F") $banque="ESPECES FUTUNA";
                $espece=true;
            }
            
            $montant_eur=round(($versement->montant_r+$versement->montant)*0.00838,2);
            $just_add=false;
            if(($banque_old!=$banque)||($i==0)||($nb_ligne>$nbmax_ligne)) {         
                if( ($i>0)&&($banque_old!=$versement->banque) ) {
                    //Sous total
                    $this->sous_total($fpdf,$tot,$espece,$w,$h/2);
                    if($fpdf->GetY()>230) {
                        $fpdf->AddPage();
                        $this->Header($fpdf,$titre_doc);
                        $just_add=true;
                    }
                    $tot=["nb_alloc"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];
                }
                if(($i>0)&&(!$just_add)) {
                    $this->Footer($fpdf,$user);
                    $fpdf->AddPage();
                    $this->Header($fpdf,$titre_doc);
                }
                $nb_ligne=0;
                $fpdf->ln($h);
                $fpdf->SetX($depX);
                $fpdf->SetFont($font,'BU',$font_size+1);
                
                $fpdf->Cell(100,$h,utf8_decode($banque),"","1",'L',"");
                $fpdf->ln(5);
                $fpdf->SetX($depX);
                
                $fpdf->SetFont($font,'B',$font_size);
                $fpdf->SetFont($font,'B',$font_size);
                $nom_col=$col_def;
                if($espece) $nom_col=$col_def_espece;
                foreach($nom_col as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                $fpdf->SetFont($font,'',$font_size);
            }
            $k=0;
            $bordure="BLR";
            $fpdf->ln($h);$fpdf->SetX($depX);
            $fpdf->Cell($w[$k++],$h,$versement->id_allocataire,$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$nom,$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$prenom,$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant_r,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant,0,","," "),$bordure,0,'R');
            if(!$espece) {
                $fpdf->Cell($w[$k++],$h,number_format($montant_eur,2,","," "),$bordure,0,'R');
                $fpdf->Cell($w[$k],$h/2,$titulaire,"TLR",2,'C');
                $fpdf->Cell($w[$k],$h/2,$versement->compte,"BLR",0,'C');
                $fpdf->SetY($fpdf->GetY()-$h/2);
            } else {
                $fpdf->Cell($w[$k++],$h,"",$bordure,0,'L');
                $fpdf->Cell($w[$k++],$h,"",$bordure,0,'L');
            } 
            $banque_old=$banque;
            $tot["nb_alloc"]+=1;
            $tot["rappel"]+=$versement->montant_r;
            $tot["montant"]+=$versement->montant;
            $tot["montant_eur"]+=$montant_eur;
            //Sous total types
            $tot_g["cfp"]+=$versement->montant;
            $tot_g["eur"]+=$montant_eur;
            $tot_g["nb_alloc"]++;
            //Billetage
            if(!$versement->id_banque) $this->billetage($versement,$tot_g);
            $nb_ligne++;$i++;
        }
        //Dernier total

        $this->Footer($fpdf,$user);
        $fpdf->AddPage();
        $this->Header($fpdf,$titre_doc);
        //Tableau TOTAL
        $this->Footer_total($fpdf,$tot_g,$type_aide);

        //Tableau Billetage
        $fpdf->ln(10);
        $this->Footer_billetage($fpdf,$tot_g);
        //Visas
        $this->Footer_Visas($fpdf,$user);

        $this->Footer($fpdf,$user);
        $fpdf->Output($nom_fichier,"I");
        exit(); 
    }

    function sous_total($fpdf,$tot,$espece,$w,$h)
    {
        //Dernier total
        $depX=5;
        $font="Arial";$font_size=8;
        $fpdf->ln($h*2);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0]+$w[1],$h,utf8_decode("Nombre de bénéficiaires : "." ".$tot["nb_alloc"]),"",0,'L');
        $fpdf->SetFont($font,'B',$font_size);
        $fpdf->Cell($w[2],$h,"Totaux :","",0,'R');
        $fpdf->SetFont($font,'B',$font_size);
        $fpdf->Cell($w[3],$h,number_format($tot["rappel"],0,","," "),"TBLR",0,'R',1);
        $fpdf->Cell($w[4],$h,number_format($tot["montant"],0,","," "),"TBLR",0,'R',1);
        if(!$espece) $fpdf->Cell($w[5],$h,number_format($tot["montant_eur"],2,","," ")." ".chr(128),"TBLR",0,'R',1);
        $fpdf->ln(5);

    }

    function Header($fpdf,$titre_doc)
    {
        //Titre
        $fpdf->SetFont("Arial",'',14);
        $fpdf->SetX(35);
        $fpdf->SetFillColor(135,206,250);
        $fpdf->Cell(140,7,utf8_decode($titre_doc),"",0,'C',"1");
        $fpdf->SetFont("Arial",'',7);
        $fpdf->Cell(30,7,date("d/m/Y"),"",1,'R',"");
    }

    function Footer($fpdf,$user)
    {
        //Titre
        $fpdf->SetFont("Arial",'',7);
        $fpdf->SetY(285);
        $fpdf->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $fpdf->Cell(60,7,utf8_decode("Edité par ".$user->name),"T",0,'L');
        $fpdf->Cell(100,7,"SITAS - BP 385 MATA UTU - 98600 WALLIS - TEL : 72 01 67","T",0,'C');
        $fpdf->Cell(50,7,$fpdf->PageNo().'/{nb}',"T",0,'R');
    }


    function Footer_total($fpdf,$tot_g,$type_aide)
    {
        $depX=5;$h=7;
        $font="Arial";
        $fpdf->ln(15);
        //Titre
        $fpdf->SetFont($font,'B',10);
        $fpdf->SetX($depX+20);
        $fpdf->Cell(100,$h,utf8_decode("Nombre total de bénéficiaire : ").$tot_g['nb_alloc'],"","1",'L');
        $fpdf->ln(5);
        $w=array(50,30,30,30);

        $fpdf->SetFillColor(240,248,255);
        $fpdf->SetX($depX+20);
        $fpdf->SetFont($font,'B',9);
        $fpdf->Cell($w[0],$h,"","",0,'L');
        $fpdf->Cell($w[1],$h,"CFP","LTR",0,'C',1);
        $fpdf->Cell($w[2],$h,"EUR","LTR",0,'C',1);
        $fpdf->ln();

        $fpdf->SetX($depX+20);
        $fpdf->Cell($w[0],$h,"TOTAUX:","LTB",0,'L',1);
        $fpdf->SetFont($font,'',9);
        $fpdf->Cell($w[1],$h,number_format($tot_g["cfp"],0,","," "),"LTRB",0,'C');
        $fpdf->Cell($w[2],$h,number_format($tot_g["eur"],0,","," "),"LTRB",0,'C');
        $fpdf->ln();

        $fpdf->SetX($depX+20);$y_pos=$fpdf->GetY();
        $fpdf->SetFont($font,'B',9);
        $fpdf->MultiCell($w[0],$h,"Dont TOTAUX BANQUES HORS TERRITOIRE","LTB",'L',1);
        $fpdf->SetFont($font,'',9);
        $fpdf->SetY($y_pos);
        $fpdf->SetX($depX+20+$w[0]);
        $fpdf->Cell($w[1],$h+$h,number_format($tot_g["cfp_h"],0,","," "),"LBTR",0,'C');
        $fpdf->Cell($w[2],$h+$h,number_format($tot_g["eur_h"],2,","," "),"LBTR",0,'C');
    }


    function Footer_billetage($fpdf,$tot_g)
    {
        //Billetage 
        $font="Arial";
        $l=70;$h=7;$depX=50;

        $fpdf->SetX($depX);
        $img_x=40;
        $img_y=$fpdf->GetY()+11;
        $fpdf->Image(url('img/billetage.png'),$img_x,$img_y,130,90.7);

        $x=140;$y=$img_y+14;$l=21;
        $delta_X=57;$delta_Y=15;$hh=8.2;
        $pos_idx=1;
        $fpdf->SetFont($font,'B',11);

        $fpdf->SetY($img_y+$delta_Y);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_10K_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_10K"]-$tot_g["nb_10K_F"]),"",0,'C');
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_10K"],"",0,'C');

        $fpdf->SetY($img_y+$delta_Y+$hh);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_5K_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_5K"]-$tot_g["nb_5K_F"]),"",0,'C');
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_5K"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_1K_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_1K"]-$tot_g["nb_1K_F"]),"",0,'C');
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_1K"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_500_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_500"]-$tot_g["nb_500_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_500"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_200_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_200"]-$tot_g["nb_200_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_200"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_100_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_100"]-$tot_g["nb_100_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_100"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_50_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_50"]-$tot_g["nb_50_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_50"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_20_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_20"]-$tot_g["nb_20_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_20"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_10_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_10"]-$tot_g["nb_10_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_10"],"",0,'C');
    }

    function Footer_Visas($fpdf,$user)
    {
        //Visas
        $font="Arial";
        $font_size=8;
        $depX=40;
        $h=5;
        $fpdf->ln(20);
        $fpdf->SetX($depX);
        $d=$h+6;$lrg=40;$lrg2=90;
        $fpdf->SetFont($font,'',$font_size);
        $fpdf->Cell($lrg,$d,"VISA CHEF DE SERVICE","LRT",0,'C');
        $fpdf->Cell($lrg2,$d,"","LRT",1,'C');
        $fpdf->SetX($depX);
        $fpdf->Cell($lrg,$d,"Date","RLB",0,'C');
        $fpdf->Cell($lrg2,$d,"","RLB",1,'C');

        $fpdf->SetX($depX);
        $fpdf->Cell($lrg,$d,"VISA DIRECTEUR","LRT",0,'C');
        $fpdf->Cell($lrg2,$d,"","LRT",1,'C');
        $fpdf->SetX($depX);
        $fpdf->Cell($lrg,$d,"Date","RLB",0,'C');
        $fpdf->Cell($lrg2,$d,"","RLB",1,'C');
    }

    function billetage($versement,&$tot_g) {
        $tot_billet=$versement->montant+$versement->montant_r;
        $ent_10000=(int)($tot_billet/10000);
        $reste=$tot_billet-($ent_10000*10000);

        $ent_5000=(int)($reste/5000);
        $reste=$reste-($ent_5000*5000);

        $ent_1000=(int)($reste/1000);
        $reste=$reste-($ent_1000*1000);

        $ent_500=(int)($reste/500);
        //AJOUT PIECES
        $reste=$reste-($ent_500*500);
        $ent_200=(int)($reste/200);
        $reste=$reste-($ent_200*200);

        $ent_100=(int)($reste/100);
        $reste=$reste-($ent_100*100);

        $ent_50=(int)($reste/50);
        $reste=$reste-($ent_50*50);

        $ent_20=(int)($reste/20);
        $reste=$reste-($ent_20*20);

        $ent_10=(int)($reste/10);


        $tot_g["nb_10K"]+=$ent_10000;
        $tot_g["nb_5K"]+=$ent_5000;
        $tot_g["nb_1K"]+=$ent_1000;
        $tot_g["nb_500"]+=$ent_500;
        $tot_g["nb_200"]+=$ent_200; 
        $tot_g["nb_100"]+=$ent_100;
        $tot_g["nb_50"]+=$ent_50;
        $tot_g["nb_20"]+=$ent_20;
        $tot_g["nb_10"]+=$ent_10;

        if($versement->ile=="F") {
            $tot_g["nb_10K_F"]+=$ent_10000;
            $tot_g["nb_5K_F"]+=$ent_5000;
            $tot_g["nb_1K_F"]+=$ent_1000;
            $tot_g["nb_500_F"]+=$ent_500; 
            $tot_g["nb_200_F"]+=$ent_200; 
            $tot_g["nb_100_F"]+=$ent_100;
            $tot_g["nb_50_F"]+=$ent_50;
            $tot_g["nb_20_F"]+=$ent_20;
            $tot_g["nb_10_F"]+=$ent_10;   
        }
        return true;
    }


}