<?php namespace App\Http\Controllers\Editions;


use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
use DB;
use App\Http\Controllers\Controller;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsVersementsListeDfipController extends Controller {
    /**
     * Liste des virements DFIP
     */
    //Contribution Sociale de Retraite
    public function imprimer_dfip_csr($num_imp="") {return $this->imprimer($num_imp,"CSR","DFIP"); }
    //Aide à l'enfant
    public function imprimer_dfip_aae($num_imp="") {return $this->imprimer($num_imp,"AAE","DFIP"); }
    //Prime a la naissance
    public function imprimer_dfip_pan($num_imp="") {return $this->imprimer($num_imp,"PAN","DFIP"); }
    //Filet Social
    public function imprimer_dfip_fso($num_imp="") {return $this->imprimer($num_imp,"FSO","DFIP"); }

    /**
     * Liste des virements AUTRES
     */
    //Contribution Sociale de Retraite
    public function imprimer_vrmt_csr($num_imp="") {return $this->imprimer($num_imp,"CSR","AUTRE"); }
    //Aide à l'enfant
    public function imprimer_vrmt_aae($num_imp="") {return $this->imprimer($num_imp,"AAE","AUTRE"); }
    //Prime a la naissance
    public function imprimer_vrmt_pan($num_imp="") {return $this->imprimer($num_imp,"PAN","AUTRE"); }
    //Filet Social
    public function imprimer_vrmt_fso($num_imp="") {return $this->imprimer($num_imp,"FSO","AUTRE"); }

    public function imprimer($num_imp,$type_aide,$type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $num_imp_PAD=str_pad($num_imp,4, "0", STR_PAD_LEFT);
        $date=date('d/m/Y');
        $titre="";
        $titre="Versement ".MyApp::PREFIXE_AIDES[$type_aide].MyApp::TYPES_AIDES[$type_aide];
        $titre_doc=$titre;
        
        $nom_fichier="versements_".$type_aide."_".date("Y_m_d").$num_imp_PAD.".pdf";
        $font="Arial";
        $titre.=" N°".$num_imp_PAD;
        $total=0;
        $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)
            ->whereNotNull("id_banque")
            ->distinct()->orderby('id_banque')
            ->orderby('destinataire_nom')
            ->orderby('destinataire_prenom')->get();  
        if($type=="DFIP") {
            $titre2="VIREMENT COMPTE D.F.I.P";
            $versements=$versements->where('id_banque','=',2);
        } else {
            $titre2="VIREMENTS AUTRES";
            $versements=$versements->where('id_banque','<>',2);
        }

        if($versements->count()==0) {
            $msg="Aucun ".$titre." pour le critère : ".$titre2;
            Session::flash('message', $msg);
            return Redirect::back();
        };
        foreach($versements as $versement) $total+=$versement->montant_r+$versement->montant;
        $date=$versement->date;
        $annee=substr($date,0,4);
        $mois=MyApp::MOIS_NUM[substr($date,5,2)];
        $titre3=$mois."-".$annee;

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AliasNbPages();
        $fpdf->SetAutoPageBreak(false,5);
        $fpdf->AddPage("L");
        //Titre Service
        
        //Titre
        $depX=5;
        $fpdf->SetFont($font,'',14);
        $fpdf->SetX($depX);
        $fpdf->SetFillColor(135,206,250);
        $this->Header($fpdf,$titre_doc,$titre2,$titre3);

        //Liste des Versements
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',8);
        $w=array(9,59,10,18,40,58,42,17,17,17);
        $col_def=array('N°'=> $w[0],'Allocataire' => $w[1],"NbEnf" =>$w[2],"Naissance" =>$w[3],
            "Bque/ModePmt" =>$w[4],"Titulaire" =>$w[5],"Compte" =>$w[6],
            "Rappel" =>$w[7],"Montant" =>$w[8],"Total" =>$w[9]);    

        $h=6;$h2=8;$cadre="";
        $nb_ligne=0;$nbmax_ligne=13;
        $w_tot=$w[0]+$w[1]+$w[2]+$w[3]+$w[4]+$w[5]+$w[6]+$w[7]+$w[8]+$w[9];
        $fpdf->ln($h);

        //TOTAL
        $w_totlabel=$w[7]+$w[8]+$w[9];
        $fpdf->SetFont($font,'B',14);
        $fpdf->SetX($depX);
        $fpdf->Cell($w_tot- $w_totlabel,$h2,"TOTAL","LRTB",0,'C');
        $fpdf->Cell( $w_totlabel,$h2,number_format($total,0,","," ")." XPF","LRTB",1,'C');

        //Titre
        $fpdf->SetFont($font,'',7);
        $fpdf->SetX($depX);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
        $fpdf->ln($h);
        foreach($versements as $versement) {
            $bordure="BLR";$k=0;
            $nom=$versement->getAllocataireNomCompletReduit(30);
            $banque=($versement->mode_versement!="VIR")?"NUMERAIRE":$banque=$versement->BanqueNom;

            if($fpdf->GetY()>190) {
                $this->Footer($fpdf,$user);
                $fpdf->AddPage("L");
                $this->Header($fpdf,$titre_doc,$titre2,$titre3);
                $fpdf->ln($h);
                $fpdf->SetX($depX);
                $fpdf->SetFont($font,'',7);
                foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                $fpdf->ln($h);
                
            }
            $titulaire=$versement->titulaire;
            if(strlen($titulaire)>40) $titulaire=substr($titulaire,0,40);
            if(strlen($banque)>25) $banque=substr($banque,0,25);
            $fpdf->SetX($depX);
            $fpdf->Cell($w[$k++],$h,$versement->AllocataireIdPAD,$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($nom, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->nb_enf, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->AllocataireDateNaissance, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($banque, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($titulaire, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$versement->compte,$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant_r,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant_r+$versement->montant,0,","," "),$bordure,1,'R');
            $nb_ligne++;
        }
        //TOTAL
        $fpdf->SetFont($font,'B',14);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0]+$w[1]+$w[2]+$w[3]+$w[4]+$w[5]+$w[6],$h*2,"TOTAL","LRTB",0,'C');
        $fpdf->Cell($w[7]+$w[8]+$w[9],$h*2,number_format($total,0,","," ")." XPF","LRTB",0,'C');
        
        //Visas
        if($fpdf->GetY()>120) {
            $this->Footer($fpdf,$user);
            $fpdf->AddPage("L");
            $this->Header($fpdf,$titre_doc,$titre2,$titre3);
            $fpdf->ln($h);
            $fpdf->SetX($depX);
        }
        $this->Footer_Visas($fpdf,$user);

        //Fin
        $this->Footer($fpdf,$user);
        $fpdf->Output($nom_fichier,"I");
        exit(); 
    }


    function Header($fpdf,$titre1,$titre2,$titre3)
    {
        $cadre=0;
        //Titre
        $fpdf->SetFont("Arial",'',12);
        $fpdf->SetX(40);
        //$fpdf->SetFillColor(135,206,250);
        $fpdf->Cell(210,7,mb_convert_encoding($titre1, 'ISO-8859-1',"UTF-8"),$cadre,0,'C');
        $fpdf->Cell(30,7,date("d/m/Y"),$cadre,1,'R');
        $fpdf->SetFont("Arial",'B',14);
        $fpdf->SetX(40);
        $fpdf->Cell(210,7,mb_convert_encoding($titre2, 'ISO-8859-1',"UTF-8"),$cadre,1,'C');
        $fpdf->SetFont("Arial",'',7);
        //ANNEE
        $fpdf->SetFont("Arial",'B',14);
        $fpdf->SetX(40);
        $fpdf->Cell(210,7,mb_convert_encoding($titre3, 'ISO-8859-1',"UTF-8"),$cadre,1,'C');
    }

    function Footer($fpdf,$user)
    {
        //Titre
        $fpdf->SetFont("Arial",'',7);
        $fpdf->SetY(205);
        $fpdf->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $fpdf->Cell(60,7,mb_convert_encoding("Edité par ".$user->name, 'ISO-8859-1',"UTF-8"),"T",0,'L');
        $fpdf->Cell(178,7,MyApp::SITAS_ADRESSE,"T",0,'C');
        $fpdf->Cell(50,7,$fpdf->PageNo().'/{nb}',"T",0,'R');
    }

    function Footer_Visas($fpdf,$user)
    {
        //Visas
        $depX=100;
        $h=8;
        $fpdf->ln(20);
        $fpdf->SetX($depX);
        $lrg=100;
        $nom_directeur=MyApp::getParam("EDI_DIRECTEUR");
        $fpdf->SetFont("Arial",'',14);
        $fpdf->Cell($lrg,$h,"VISA","LRTB",2,'C');
        $fpdf->Cell($lrg,$h,mb_convert_encoding($nom_directeur, 'ISO-8859-1',"UTF-8"),"LRT",2,'C');
        $fpdf->Cell($lrg,$h,"DIRECTEUR DU SITAS","LR",2,'C');
        $fpdf->Cell($lrg,$h*4,"","LRB",2,'C');
        $fpdf->SetX($depX);
    }

}