<?php namespace App\Http\Controllers\Editions;


use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use Illuminate\Support\Collection;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
use DB;
use App\Http\Controllers\Controller;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsVersementsListeEmargementController extends Controller {
    /**
     * Liste des virements DFIP
     */
    //Contribution Sociale de Retraite
    public function imprimer_csr($num_imp="",$ile="W") {return $this->imprimer($num_imp,"CSR",$ile); }
    //Aide à l'enfant
    public function imprimer_aae($num_imp="",$ile="W") {return $this->imprimer($num_imp,"AAE",$ile); }
    //Prime a la naissance
    public function imprimer_pan($num_imp="",$ile="W") {return $this->imprimer($num_imp,"PAN",$ile); }
    //Prime a la naissance
    public function imprimer_fso($num_imp="",$ile="W") {return $this->imprimer($num_imp,"FSO",$ile); }


    public function imprimer($num_imp,$type_aide,$ile="W")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $num_imp_PAD=str_pad($num_imp,4, "0", STR_PAD_LEFT);
        $date=date('d/m/Y');
        $titre="";
        $titre="Versement ".MyApp::PREFIXE_AIDES[$type_aide].MyApp::TYPES_AIDES[$type_aide];
        $titre_doc=$titre;
        
        $nom_fichier="versements_emmargement_".$type_aide."_".date("Y_m_d").$num_imp_PAD.".pdf";
        $font="Arial";
        $titre.=" N°".$num_imp_PAD;
        $total=0;$max_nom_size=36;$max_procuration_size=40;
        $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)
            ->whereNull("id_banque")
            ->where("ile","=",$ile)
            ->distinct()
            ->orderby('district')
            ->orderby('village')
            ->orderby('destinataire_nom')
            ->orderby('destinataire_prenom')->get();  
        $titre2="VERSEMENTS EN NUMERAIRE - ".MyApp::ILES[$ile];

        foreach($versements as $versement) $total+=$versement->montant_r+$versement->montant;
        $date=$versement->date;
        $annee=substr($date,0,4);
        $mois=MyApp::MOIS_NUM[substr($date,5,2)];
        $titre3=$mois."-".$annee;

        //Villages totaux
        $total=array();
        foreach($versements as $versement) {
            if(!isset( $total[$versement->village]["montant"])) {
                $total[$versement->village]["montant"]=0;
                $total[$versement->village]["nb"]=0;
            }
        }

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AliasNbPages();
        $fpdf->SetAutoPageBreak(false,5);
        $fpdf->AddPage("L");
        //Titre Service
        
        //Titre
        $depX=5;
        $fpdf->SetFont($font,'',14);
        $fpdf->SetX($depX);
        $fpdf->SetFillColor(234,112,108);
        $this->Header($fpdf,$titre_doc,$titre2,$titre3);

        $versement_first=$versements->first();
        $fpdf->ln();
        $fpdf->Cell(280,7,mb_convert_encoding($versement_first->village, 'ISO-8859-1',"UTF-8"),0,0,'C');


        //Liste des Versements
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',8);
        $w=array(17,18,25,75,20,20,60,52);
        $col_def=array('Ile' => $w[0],'District' => $w[1],"Village" => $w[2],
            'Allocataire' => $w[3],"Naissance" =>$w[4],
            "Total" =>$w[5],"Procuration" =>$w[6],"Emargement" =>$w[7],);     

        $h=12;$h2=8;$cadre="";
        $nb_ligne=0;$nbmax_ligne=13;
        $fpdf->ln($h);

        //Titre
        $fpdf->SetFont($font,'B',10);
        $fpdf->SetX($depX);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',($name!="Emargement")?1:0);
        $fpdf->ln($h);
        $fpdf->SetFont($font,'',10);
        $old_village="";
        foreach($versements as $versement) {
            $bordure="BLR";$k=0;
            $nom=$versement->destinataire_nom." ".$versement->destinataire_prenom;
            if(strlen($nom)>$max_nom_size) $nom=substr($nom,0,$max_nom_size).".";
            //$nom=$versement->getAllocataireNomCompletReduit($max_nom_size);
            
            if($nb_ligne>0 && (($fpdf->GetY()>190)||($old_village!=$versement->village))) {

                if($old_village!=$versement->village) 
                    $this->FooterTotal($fpdf,$user,$w,$total,$old_village);
                $this->Footer($fpdf,$user,$w,$total[$versement->village]);
                $fpdf->AddPage("L");
                $this->Header($fpdf,$titre_doc,$titre2,$titre3);
                $fpdf->ln($h);
                $fpdf->Cell(280,7,mb_convert_encoding($versement->village, 'ISO-8859-1',"UTF-8"),$cadre,0,'C');
                $fpdf->ln($h);
                $fpdf->SetX($depX);
                $fpdf->SetFont($font,'B',10);
                foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',($name!="Emargement")?1:0);
                $fpdf->SetFont($font,'',10);
                $fpdf->ln($h);
            }
            $ile=($versement->ile=="W")?"WALLIS":"FUTUNA";
            $procuration=$versement->procuration_nom." ".$versement->procuration_prenom." ".$versement->ProcurationDateNaissance;
            if(strlen($procuration)>$max_procuration_size) $procuration=substr($procuration,0,$max_procuration_size);
            $fpdf->SetX($depX);
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($ile, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->district, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->village, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($nom, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->AllocataireDateNaissance, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant_r+$versement->montant,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($procuration, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,"",$bordure,1,'R');            
            $nb_ligne++;
            $old_village=$versement->village;
            $total[$versement->village]["montant"]+=$versement->montant_r+$versement->montant;
            $total[$versement->village]["nb"]++;
        }

        //Fin
        $this->FooterTotal($fpdf,$user,$w,$total,$versement->village);
        $this->Footer($fpdf,$user,$w,$total[$versement->village]);
        
        $fpdf->Output($nom_fichier,"I");
        exit(); 
    }


    function Header($fpdf,$titre1,$titre2,$titre3)
    {
        $cadre=0;
        //Titre
        $fpdf->SetFont("Arial",'',12);
        $fpdf->SetX(40);
        //$fpdf->SetFillColor(135,206,250);
        $fpdf->Cell(210,7,mb_convert_encoding($titre1, 'ISO-8859-1',"UTF-8"),$cadre,0,'C');
        $fpdf->Cell(30,7,date("d/m/Y"),$cadre,1,'R');
        $fpdf->SetFont("Arial",'B',14);
        $fpdf->SetX(40);
        $fpdf->Cell(210,7,mb_convert_encoding($titre2, 'ISO-8859-1',"UTF-8"),$cadre,1,'C');
        $fpdf->SetFont("Arial",'',7);
        //ANNEE
        $fpdf->SetFont("Arial",'B',14);
        $fpdf->SetX(40);
        $fpdf->Cell(210,7,mb_convert_encoding($titre3, 'ISO-8859-1',"UTF-8"),$cadre,1,'C');
    }


    function FooterTotal($fpdf,$user,$w,$total,$village)
    {
        $depX=5;        
        $fpdf->SetX($depX);
        $fpdf->SetFont("Arial",'B',11);
        $fpdf->Cell($w[0]+$w[1]+$w[2]+$w[3],7,"",0,0,'R');
        $fpdf->Cell($w[4],7,mb_convert_encoding("TOTAL", 'ISO-8859-1',"UTF-8"),0,0,'C');
        $fpdf->Cell($w[5],7,number_format($total[$village]["montant"],0,","," "),1,0,'R');
    }

    function Footer($fpdf,$user)
    {
        //Titre
        $fpdf->SetFont("Arial",'',7);
        $fpdf->SetY(205);
        $fpdf->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $fpdf->Cell(60,7,mb_convert_encoding("Edité par ".$user->name, 'ISO-8859-1',"UTF-8"),"T",0,'L');
        $fpdf->Cell(178,7,MyApp::SITAS_ADRESSE,"T",0,'C');
        $fpdf->Cell(50,7,$fpdf->PageNo().'/{nb}',"T",0,'R');
    }

    function Footer_Visas($fpdf,$user)
    {
        //Visas
        $depX=100;
        $h=8;
        $fpdf->ln(20);
        $fpdf->SetX($depX);
        $lrg=100;
        $nom_directeur=MyApp::getParam("EDI_DIRECTEUR");
        $fpdf->SetFont("Arial",'',14);
        $fpdf->Cell($lrg,$h,"VISA","LRTB",2,'C');
        $fpdf->Cell($lrg,$h,mb_convert_encoding($nom_directeur, 'ISO-8859-1',"UTF-8"),"LRT",2,'C');
        $fpdf->Cell($lrg,$h,"DIRECTEUR DU SITAS","LR",2,'C');
        $fpdf->Cell($lrg,$h*4,"","LRB",2,'C');
        $fpdf->SetX($depX);
    }

}