<?php namespace App\Http\Controllers\Editions;


use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
use DB;
use App\Http\Controllers\Controller;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsVersementsListeNumeraireController extends Controller {
    /**
     * Liste des virements DFIP
     */
    //Contribution Sociale de Retraite
    public function imprimer_csr($num_imp="") {return $this->imprimer($num_imp,"CSR"); }
    //Aide à l'enfant
    public function imprimer_aae($num_imp="") {return $this->imprimer($num_imp,"AAE"); }
    //Prime a la naissance
    public function imprimer_pan($num_imp="") {return $this->imprimer($num_imp,"PAN"); }
    //Prime a la naissance
    public function imprimer_fso($num_imp="") {return $this->imprimer($num_imp,"FSO"); }


    public function imprimer($num_imp,$type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $num_imp_PAD=str_pad($num_imp,4, "0", STR_PAD_LEFT);
        $date=date('d/m/Y');
        $titre="";
        $titre="Versement ".MyApp::PREFIXE_AIDES[$type_aide].MyApp::TYPES_AIDES[$type_aide];
        $titre_doc=$titre;
        
        $nom_fichier="versements_".$type_aide."_".date("Y_m_d").$num_imp_PAD.".pdf";
        $font="Arial";
        $titre.=" N°".$num_imp_PAD;
        $total=0;$max_nom_size=50;$max_procuration_size=40;
        $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)
            ->whereNull("id_banque")
            ->distinct()->orderby('id_banque')
            ->orderby('ile')
            ->orderby('district')
            ->orderby('village')
            ->orderby('destinataire_nom')
            ->orderby('destinataire_prenom')->get();  
        $titre2="VERSEMENTS EN NUMERAIRE";
        

        foreach($versements as $versement) $total+=$versement->montant_r+$versement->montant;
        $date=$versement->date;
        $annee=substr($date,0,4);
        $mois=MyApp::MOIS_NUM[substr($date,5,2)];
        $titre3=$mois."-".$annee;

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AliasNbPages();
        $fpdf->SetAutoPageBreak(false,5);
        $fpdf->AddPage("L");
        //Titre Service
        
        //Titre
        $depX=5;
        $fpdf->SetFont($font,'',14);
        $fpdf->SetX($depX);
        $fpdf->SetFillColor(135,206,250);
        $this->Header($fpdf,$titre_doc,$titre2,$titre3);

        //Liste des Versements
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',8);
        $w=array(10,70,10,20,25,10,18,60,20,20,20);
        $col_def=array('N°'=> $w[0],'Allocataire' => $w[1],'Ile' => $w[2],'District' => $w[3],
            "Village" => $w[4],"NbEnf" =>$w[5],"Naissance" =>$w[6],
            "Procuration" =>$w[7],"Rappel" =>$w[8],"Montant" =>$w[9],"Total" =>$w[10]);     

        $h=6;$h2=8;$cadre="";
        $nb_ligne=0;$nbmax_ligne=13;
        $w_tot=$w[0]+$w[1]+$w[2]+$w[3]+$w[4]+$w[5]+$w[6]+$w[7]+$w[8]+$w[9]+$w[10];
        $w_totlabel=$w[0]+$w[1]+$w[2]+$w[3]+$w[4]+$w[5]+$w[6]+$w[7];
        $fpdf->ln($h);

        //TOTAL
        $fpdf->SetFont($font,'B',14);
        $fpdf->SetX($depX);
        $fpdf->Cell($w_totlabel,$h2,mb_convert_encoding("TOTAL DE L'ENGAGEMENT : ", 'ISO-8859-1',"UTF-8"),"LRTB",0,'C');
        $fpdf->Cell( $w_tot-$w_totlabel,$h2,number_format($total,0,","," ")." XPF","LRTB",1,'C');

        //Titre
        $fpdf->SetFont($font,'',7);
        $fpdf->SetX($depX);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
        $fpdf->ln($h);
        foreach($versements as $versement) {
            $bordure="BLR";$k=0;
            $nom=$versement->getAllocataireNomCompletReduit($max_nom_size);
            if($fpdf->GetY()>190) {
                $this->Footer($fpdf,$user);
                $fpdf->AddPage("L");
                $this->Header($fpdf,$titre_doc,$titre2,$titre3);
                $fpdf->ln($h);
                $fpdf->SetX($depX);
                $fpdf->SetFont($font,'',7);
                foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                $fpdf->ln($h);
                
            }
            $procuration=$versement->procuration;
            if(strlen($procuration)>$max_procuration_size) $procuration=substr($procuration,0,$max_procuration_size);
            $fpdf->SetX($depX);
            $fpdf->Cell($w[$k++],$h,$versement->AllocataireIdPAD,$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($nom, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->ile, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->district, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->village, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->nb_enf, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->AllocataireDateNaissance, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($procuration, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant_r,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,number_format($versement->montant_r+$versement->montant,0,","," "),$bordure,1,'R');
            $nb_ligne++;
        }
        //TOTAL
        $fpdf->SetFont($font,'B',14);
        $fpdf->SetX($depX);
        $fpdf->Cell($w_totlabel,$h2,mb_convert_encoding("TOTAL DE L'ENGAGEMENT : ", 'ISO-8859-1',"UTF-8"),"LRTB",0,'C');
        $fpdf->Cell( $w_tot-$w_totlabel,$h2,number_format($total,0,","," ")." XPF","LRTB",1,'C');
        
        //Visas
        if($fpdf->GetY()>120) {
            $this->Footer($fpdf,$user);
            $fpdf->AddPage("L");
            $this->Header($fpdf,$titre_doc,$titre2,$titre3);
            $fpdf->ln($h);
            $fpdf->SetX($depX);
        }
        $this->Footer_Visas($fpdf,$user);

        //Fin
        $this->Footer($fpdf,$user);
        $fpdf->Output($nom_fichier,"I");
        exit(); 
    }


    function Header($fpdf,$titre1,$titre2,$titre3)
    {
        $cadre=0;
        //Titre
        $fpdf->SetFont("Arial",'',12);
        $fpdf->SetX(40);
        //$fpdf->SetFillColor(135,206,250);
        $fpdf->Cell(210,7,mb_convert_encoding($titre1, 'ISO-8859-1',"UTF-8"),$cadre,0,'C');
        $fpdf->Cell(30,7,date("d/m/Y"),$cadre,1,'R');
        $fpdf->SetFont("Arial",'B',14);
        $fpdf->SetX(40);
        $fpdf->Cell(210,7,mb_convert_encoding($titre2, 'ISO-8859-1',"UTF-8"),$cadre,1,'C');
        $fpdf->SetFont("Arial",'',7);
        //ANNEE
        $fpdf->SetFont("Arial",'B',14);
        $fpdf->SetX(40);
        $fpdf->Cell(210,7,mb_convert_encoding($titre3, 'ISO-8859-1',"UTF-8"),$cadre,1,'C');
    }

    function Footer($fpdf,$user)
    {
        //Titre
        $fpdf->SetFont("Arial",'',7);
        $fpdf->SetY(205);
        $fpdf->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $fpdf->Cell(60,7,mb_convert_encoding("Edité par ".$user->name, 'ISO-8859-1',"UTF-8"),"T",0,'L');
        $fpdf->Cell(178,7,MyApp::SITAS_ADRESSE,"T",0,'C');
        $fpdf->Cell(50,7,$fpdf->PageNo().'/{nb}',"T",0,'R');
    }

    function Footer_Visas($fpdf,$user)
    {
        //Visas
        $depX=100;
        $h=8;
        $fpdf->ln(20);
        $fpdf->SetX($depX);
        $lrg=100;
        $nom_directeur=MyApp::getParam("EDI_DIRECTEUR");
        $fpdf->SetFont("Arial",'',14);
        $fpdf->Cell($lrg,$h,"VISA","LRTB",2,'C');
        $fpdf->Cell($lrg,$h,mb_convert_encoding($nom_directeur, 'ISO-8859-1',"UTF-8"),"LRT",2,'C');
        $fpdf->Cell($lrg,$h,"DIRECTEUR DU SITAS","LR",2,'C');
        $fpdf->Cell($lrg,$h*4,"","LRB",2,'C');
        $fpdf->SetX($depX);
    }

}