<?php namespace App\Http\Controllers\Editions;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Auth\AuthController;
use App\Models\Banque;
use App\Models\Allocataire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Versement;
use App\Models\Parametre;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Mail;


class ExportVersementsController extends Controller {
    private $menu_home="versements";
    private $menu='csr';
    private $submenu='versements_ter';

    public function __construct()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

    }


    /* ****************************** */
    /* TRESOR PUBLIC */
    /* ****************************** */
 
    public function index_export_csr($num_imp)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $type_aide="CSR";
        $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)->get();
        return View::make('versements.export.export_fichier_TP', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type_aide'=>$type_aide,
            'num_imp'=>$num_imp,
            'versements' => $versements,
        ]);
    }

    /* Exportation du fichier Tp */
    public function export_csr(Request $request,$num_imp)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $type_aide="CSR";
        $date=$request->date_export;
        $designation=$request->designation;
        $compte_sitas=$request->compte;

        $date=substr($date,0,2).substr($date,3,2).substr($date,8,2);
        $versements=Versement::where('type','=',$type_aide)
            ->where('num_imp','=',$num_imp)
            //->where("bqcleunik","<>","2") //SAUF BWF
            //->whereNotIn("bqcleunik",["0","1","58"]) //SAUF Aucune, Aucune Futuna, BWF
            ->whereNotnull("id_banque") //SAUF Aucune, Aucune Futuna, BWF
            ->get();
        $date_deb=DB::table('versements')->where('type','=',$type_aide)
            ->where('num_imp','=',$num_imp)
            ->orderby('date')
            ->first()->date;

        $nom_file="";
        $nb_lignes=0;
        //Génération du fichier
        $nomfile="SITAS_versements_".strtolower($type_aide)."_".substr($date_deb,0,6).".txt";;
        $path="./upload/tresor_public/".strtolower($type_aide);
        //création du dossier
        if(!file_exists($path)) {
            mkdir($path,'0777',true);
            chmod($path, '0755');
        }
        if(!file_exists($path)) {
            $message_err="Impossible de créer le fichier.";
        } else {
            $path_nom_file=$path."//".$nomfile;
            //ecriture du fichier
            $nb_lignes=$this->ecriture_file_complet($path_nom_file,$versements,$date,$designation,$compte_sitas);
        }

        $t_email=array();

        return View::make('versements.export.export_fichier_TP', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type_aide'=>$type_aide,
            'nom_file'=>$nomfile,
            'path_nom_file'=>$path_nom_file,
            'nb_lignes'=>$nb_lignes,
            'versements' => $versements,
            'num_imp' => $num_imp,
            't_email' => $t_email,
        ]);
    }

    public function ecriture_file_complet($path_nom_file,$versements,$date,$designation,$compte_sitas)
    {
        $fl="\r\n";
        $fp = @fopen($path_nom_file, 'w');
        if(!$fp) return false;

        //ecriture des lignes
        $j=0;
        $montant_total=0;
        $nb_lignes_total=count($versements);

        $line="";$j=1;
        $line=$this->getLigne_debut_complet($date,$designation,$compte_sitas);
        fwrite($fp, $line.$fl);
        foreach ($versements as $versement) {
            $montant_total+=$versement->montant;
            $line=$this->getLigne_complet($versement,$j,$date,$compte_sitas);
            fwrite($fp, $line.$fl);
            $j++;
        }
        $line=$this->getLigne_fin_complet($montant_total,$j,$date,$compte_sitas).$fl;
        fwrite($fp, $line);
        fclose($fp);
        return $j;
    }

    public function getLigne_complet($versement,$i,$date,$compte_sitas)
    {
        if(strlen($compte_sitas)>11) $compte_sitas=substr($compte_sitas,0,11);
        $banque_emet="10071"; //TP emetteur
        $guichet="98700"; //TP emetteur

        $allocataire=Allocataire::find($versement->id_allocataire);
        //NOM
        $nom=$versement->destinataire_nom." ".$versement->destinataire_prenom;
        $nom=strtoupper($this->str_to_noaccent($nom));
        $nom=utf8_encode($nom);
        if(strlen($nom)>24) $nom=substr($nom,0,24);
        //
        $id_banque=$versement->id_banque;
        $banque=Banque::find($id_banque);
        //TP ar défaut
        $compte_cli=$versement->compte;
        $compte_cli=substr($compte_cli,4,21); //IBAN
        $banque_cli=substr($compte_cli,0,5);
        $guichet_cli=substr($compte_cli,5,5);
        $cle_cli=substr($compte_cli,10,11);
        //dd($versement->compte." => ".$banque_cli." ".$guichet_cli." ".$compte_cli);
        $line="";
        $code_enregistrement="04";
        $code_operation="20";
        $libelle="CSR";

        $line.=$code_enregistrement;//Lg:2 Code enregistrement
        $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 N°enregistrement
        $line.=$code_operation;//Lg:2 Code opération 20
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de règlement
        $line.=str_pad("X", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque_emet;//Lg:5 Etablissement emetteur 30001
        $line.=$guichet;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_sitas, 11, " ");//Lg:11 compte emetteur
        //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
        //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers
        $line.=str_pad(" ", 24, " ", STR_PAD_LEFT);//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:6 inutilisés
        $line.=str_pad(" ", 5, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
        $line.=$banque_cli;//Lg:5 Etablissement destinataire 30001
        $line.=$guichet_cli;//Lg:5 Guichet destinataire
        $line.=str_pad($compte_cli, 11, "0", STR_PAD_LEFT);//Lg:11 Numéro de compte du destinataire
        $line.=str_pad($nom, 24, " ");//Lg:24 Nom/Raison sociale du destinataire
        $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
        $line.=str_pad(" ", 24, " ");//Lg:24 Domiciliation
        $line.=str_pad($libelle, 32, " ");//Lg:32 Libellé
        $line.=str_pad("", 32, " ");//Lg:32 Libellé
        $line.=str_pad(" ", 10, " ", STR_PAD_LEFT);//Lg:10 inutilisés
        $line.=str_pad(" ", 2, " ", STR_PAD_LEFT);//Lg:2 Code flux
        $line.=str_pad($versement->montant+$versement->montant_r, 12, "0", STR_PAD_LEFT);//Lg:12 Montant
        return $line;
    }

    public function getLigne_debut_complet($date,$designation,$compte_sitas)
    {
        //0100000100061119E 3000130001V754T163000DFIP
        if(strlen($compte_sitas)>11) $compte_sitas=substr($compte_sitas,0,11);
        $guichet="00005";//"10071";
        $banque="45189";//"30001";
        $nom=$designation;//"type aide";
        $line="01";//Lg:2 Code enregistrement
        $line.="000001";//Lg:6 N° Enregistrement
        $line.=str_pad("0", 2, "0", STR_PAD_LEFT); //Lg:2 inutilisés
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date échange
        $line.=str_pad("X", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque;//Lg:5 Etablissement emetteur 30001
        $line.=$guichet;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_sitas, 11, " ");//Lg:11 compte emetteur
        $line.=str_pad($designation, 24, " ", STR_PAD_RIGHT);//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 174, " ");//Lg:174 inutilisés
        return $line;

    }

    public function getLigne_fin_complet($montant_total,$i,$date,$compte_sitas)
    {
        if(strlen($compte_sitas)>11) $compte_sitas=substr($compte_sitas,0,11);
        $guichet="00005";//"10071";
        $banque="45189";//"30001";
        $line="";
        $line.="09";//Lg:2 Code enregistrement
        $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 Numéro de l'enregistrement
        $line.="20";//Lg:2 Code opération
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de reglement
        $line.=str_pad("X", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque;//Lg:5 Etablissement emetteur 30001
        $line.=$guichet;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_sitas, 11, " ");//Lg:11 compte emetteur
        //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
        //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers
        $line.=str_pad(" ", 24, " ");//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 162, " ");//Lg:174 inutilisés
        $line.=str_pad($montant_total, 12, "0", STR_PAD_LEFT);//Lg:12 Montant

        return $line;
    }






/* ****************** */
/* Fonctions communes */
/* ****************** */

function str_to_noaccent($str)
{
    $url = $str;
    $url = preg_replace('#Ç#', 'C', $url);
    $url = preg_replace('#ç#', 'c', $url);
    $url = preg_replace('#è|é|ê|ë#', 'e', $url);
    $url = preg_replace('#È|É|Ê|Ë#', 'E', $url);
    $url = preg_replace('#à|á|â|ã|ä|å#', 'a', $url);
    $url = preg_replace('#@|À|Á|Â|Ã|Ä|Å#', 'A', $url);
    $url = preg_replace('#ì|í|î|ï#', 'i', $url);
    $url = preg_replace('#Ì|Í|Î|Ï#', 'I', $url);
    $url = preg_replace('#ð|ò|ó|ô|õ|ö#', 'o', $url);
    $url = preg_replace('#Ò|Ó|Ô|Õ|Ö#', 'O', $url);
    $url = preg_replace('#ù|ú|û|ü#', 'u', $url);
    $url = preg_replace('#Ù|Ú|Û|Ü#', 'U', $url);
    $url = preg_replace('#ý|ÿ#', 'y', $url);
    $url = preg_replace('#Ý#', 'Y', $url);

    return ($url);
}



}



