<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

use App\Models\Allocataire;
use App\Models\Famille;
use App\Models\FamilleMembre;
use App\Models\FamilleEnfant;
use App\Models\User;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use URL;
use App\Http\Requests\EnfantRequest;
use App\Http\Requests\AllocataireAutoRequest;
use Illuminate\Http\Request;
use App\Models\Parametre;
use App\Http\Controllers\Logs;


class EnfantsController extends Controller {

    private $menu_home="base";
    private $menu='dossiers';
    private $submenu='enfants';

    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_VISU")) return redirect('home');

        $title="";$type="";

        $day18a=MyApp::getDayNans('22');
        $enfants = Allocataire::where("date_naissance",">=",$day18a)->orderBy('nom')->orderBy('prenom')->get();//->orwhereNotNull("certificat_enfant")
        $title="Liste de tous les enfants (-18a)";
        return View::make('tiers.enfants.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,
            'enfants' => $enfants
        ]);
    }


    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_AJO")) return redirect('home');
        return $this->create_generic("create","","");
    }
    
    public function create_generic($mode,$id,$onglet_actif="o_general")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($onglet_actif=="") $onglet_actif="o_general";
        $enfant = [];
        $famille = []; $famille_enfant = [];
        if($id) {
            $enfant = Allocataire::find($id);
            $famille_enfant=FamilleEnfant::where('familles_enfants.id_enfant','=',$enfant->id )->where('id_famille','<>','null')->first();
            if($famille_enfant) $famille=Famille::find($famille_enfant->id_famille);
        }
        $ben_statuts=MyApp::getZBase("BEN_STATUT");
        $ben_statuts_dossier=MyApp::getZBase("BEN_STATUT_DOSSIER");
        $liste_certificats=MyApp::getZBase("CERT_ENFANTS");

        //$data_roles_json=json_encode(MyApp::getRolesPop()); 'data_roles_json' => $data_roles_json,
        return View::make('tiers.enfants.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'onglet_actif' => $onglet_actif,
            'ben_statuts' => $ben_statuts,
            'ben_statuts_dossier' => $ben_statuts_dossier,
            'liste_certificats' => $liste_certificats,
            'enfant' => $enfant ,
            'famille' => $famille,
            'famille_enfant' => $famille_enfant,
            ]);
    }

    public function store(EnfantRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_AJO")) return redirect('home');

        $enfant = $this->setData($request);
        //REgarde si reload
        $reload_form=isset($request->reload_form)?$request->reload_form:"";
        if($reload_form) {
            Session::put('onglet_enfant', $reload_form); 
            return Redirect::to('/enfants/'.$enfant->id);
        }
        return Redirect::to('enfants');
    }

    public function edit($id,$onglet_actif="o_general")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        $onglet_actif=Session::get("onglet_enfant");
        return $this->create_generic("edit",$id,$onglet_actif);
    }

    public function update($id,EnfantRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        $enfant = $this->setData($request,$id);

        //REgarde si reload
        $reload_form=isset($request->reload_form)?$request->reload_form:"";
        if($reload_form) {
            Session::put('onglet_enfant', $reload_form); 
            return Redirect::to('/enfants/'.$enfant->id);
        }

        return Redirect::to('enfants');

    }

    public function show($id,$onglet_actif="o_general")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_VISU")) return redirect('home');

        Session::put('previous_enfant', URL::previous());
        $onglet_actif=Session::get("onglet_enfant");
        return $this->create_generic("show",$id,$onglet_actif);
    }

    public function destroy($id,$type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_SUP")) return redirect('home');

    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        if($id=="") $enfant =  new Allocataire;
        else $enfant = Allocataire::find($id);

        $parent1=Allocataire::find($request->id_parent1);
        $enfant->id_parent1 = $request->id_parent1;
        $enfant->id_parent2 = $request->id_parent2;
        $enfant->id_famille = isset($parent1->id_famille)?$parent1->id_famille:null;
        $enfant->types_aides = ((!$request->types_aides) || count($request->types_aides)==0)?null:implode(",",$request->types_aides); 
        $enfant->nom_naissance  = strtoupper($request->nom_naissance);
        $enfant->prenom  = $request->prenom;
        $enfant->sexe = $request->sexe;
        $date=$request->date_naissance;
        $enfant->date_naissance = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $enfant->lieunaiss = $request->lieunaiss;
        $enfant->obs = $request->obs;
        $enfant->statut_dossier = $request->statut_dossier;
        $enfant->statut = $request->statut;
        $enfant->certificat_enfant = $request->certificat_enfant;
        $enfant->verrou = 0;
        $enfant->force_pan = (!$request->force_pan)?0:1;
        $enfant->save();

        $famille_enfant=FamilleEnfant::where("id_famille","=",$enfant->id_famille)->where("id_enfant","=",$enfant->id)->first();
        if($famille_enfant) {
            $famille_enfant->lien_parente=$request->lien_parente;
            $famille_enfant->save();
        }

        //LOG de la transaction
        $enfant->log_transaction($request->url(),'U');

        return $enfant;
    }



}
