<?php namespace App\Http\Controllers;

use App\Models\Famille;
use App\Models\FamilleEnfant;
use App\Models\FamilleMembre;
use App\Models\Allocataire;
use App\Models\MyApp;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\FamilleRequest;
use App\Http\Requests\FamilleAutoRequest;
use Illuminate\Http\Request;
use View;
use DB;
 
class FamillesController extends Controller {
    private $menu_home="base";
    private $menu='dossiers';
    private $submenu='familles';

    public function index($ile="",$aide="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_VISU")) return redirect('home');
        
        $title="";
        if($ile=="") $ile=MyApp::getSessionValue("select_ile","W");
        MyApp::putSessionValue("select_ile",$ile);

        if($aide=="") $aide=MyApp::getSessionValue("select_aide","");
        MyApp::putSessionValue("select_aide",$aide);

        $all_familles = Famille::all();
        $familles=collect();
        foreach($all_familles as $famille) {
            $isOK=true;
            if($ile) if($famille->Ile!=$ile) $isOK=false;
            if($aide) if(!$famille->hasAide($aide)) $isOK=false;
            if($isOK) $familles->push($famille);
        }

        return View::make('familles.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title'=>$title,'ile'=>$ile,'aide'=>$aide,
            'familles'=>$familles
        ]);
    }
 
    
   
    public function create_dossier($id)
    {
        $allocataire=Allocataire::find($id);
        $famille=Famille::find($allocataire->id);
        $msg="";
        if(!$famille) {
            $famille=new Famille;
            $famille->id_titulaire=$allocataire->id;
            $famille->save();
            $allocataire->id_famille=$famille->id;
            $allocataire->save();
            $msg="Le dossier famille N°".$famille->id. " a été créé";
        }
        $onglet_actif=Session::put("onglet_allocataire","o_foyer");
        Session::flash('message', $msg);
        return Redirect::to('allocataires/'.$id);
        
    }

    public function create($id,$mode="create")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $famille="";$titulaire="";$conjoint="";$membres="";$membres="";$enfantsSUP="";$enfantsLESS="";$autres="";
        if($mode!="create") {
            $famille=Famille::find($id);
            $titulaire=$famille->getTitulaire();
            $conjoint=$famille->getConjoint();
            $membres=$famille->getMembres();
            $enfantsSUP=$famille->getEnfantsSUP();
            $enfantsLESS=$famille->getEnfantsLESS();
            $autres=$famille->getAutres();
        }

        //$data_roles_json=json_encode(MyApp::getRolesPop()); 'data_roles_json' => $data_roles_json,
        return View::make('familles.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'famille' => $famille,'titulaire' => $titulaire,'conjoint' => $conjoint,
            'enfantsSUP' => $enfantsSUP,'enfantsLESS' => $enfantsLESS,'membres' => $membres,'autres'=>$autres
        ]);
    }


    public function edit($id)
    {
        return $this->create($id,"edit");
    }
 
    public function show($id)
    {
        return $this->create($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_SUP")) return redirect('home');
        $famille=Famille::find($id);
        $num=$famille->IdPAD;
        $id_famille=$famille->id;
        if(!$famille->canDelete) {
            $msg="Suppression interdite";
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }
        //Init Famille
        Allocataire::where('id_famille', '=', $id_famille)->update(['id_famille' => null]);
        
        //dd(Allocataire::where('id_famille', '=', $id_famille)->count());
        $msg="Le dossier famille N°".$num. " a été supprimée";
        Session::flash('message', $msg);
        $famille::destroy($id);
        return Redirect::to('familles');
    }
    
    


    /* ********** */
    /*    SWAP    */
    /* ********** */
    public function swap_titulaire($id_famille)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');

        $msg="";
        $famille=Famille::find($id_famille);
        if($famille->id_titulaire && $famille->id_conjoint) {
            $id_old_titulaire=$famille->id_titulaire;
            $famille->id_titulaire=$famille->id_conjoint;
            $famille->id_conjoint=$id_old_titulaire;
            $famille->save();
            $titulaire=$famille->getTitulaire();
            $msg="Le nouveau titulaire est  ".$titulaire->NomComplet;
        } else $msg="Inversion impossible !";
        Session::flash('message', $msg);
        return Redirect::back();
    }

    /* *********************** */
    /*    REPLACE TITULAIRE    */
    /* ********************** */
    public function ReplaceTitulaire($id_famille)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_AJO")) return redirect('home');

        $famille=Famille::find($id_famille);
        return View::make('familles.replace_titulaire_pop', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'famille' => $famille
        ]);
    }

    public function storeNewTitulaire(Request $request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');
        $msg="";
        $id_famille=$request->id_famille;
        $id_titulaire=$request->id_titulaire;
        $nouveau_titulaire=Allocataire::find($id_titulaire);
        $famille=Famille::find($id_famille);
        //Change ancien Titulaire
        $ancien_titulaire=Allocataire::find($famille->id_titulaire);
        if($ancien_titulaire) {
            $ancien_titulaire->id_famille=null;
            $ancien_titulaire->save();
        }
        //Set nouveau
        $famille->id_titulaire=$nouveau_titulaire->id;
        $famille->save();

        $msg="L'ancien titulaire ' ".$ancien_titulaire->NomComplet." a été remplacé par ".$nouveau_titulaire->TitulaireNomComplet." dans la famille ".$famille->IdPAD;

        Session::flash('message', $msg);
        return Redirect::back();
    }
    

    /* ********** */
    /*    ENFANTS */
    /* ********** */
    public function addEnfant($id_famille)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_AJO")) return redirect('home');

        $famille=Famille::find($id_famille);
        return View::make('familles.add_enfant_pop', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'famille' => $famille
        ]);
    }
    public function storeEnfant(Request $request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');
        
        $msg="";
        $id_famille=$request->id_famille;
        $id_enfant=$request->id_enfant;
        $enfant=Allocataire::find($id_enfant);
        //Suppression ancienne famille
        $famille_enfant =  FamilleEnfant::where("id_enfant","=",$enfant->id)->delete();
        $famille=Famille::find($id_famille);
        
        if($id_enfant && $id_famille) {
            $famille_enfant =  new FamilleEnfant;
            $famille_enfant->id_famille=$id_famille;
            $famille_enfant->id_enfant=$id_enfant;
            $famille_enfant->lien_parente="ENF";
            $famille_enfant->save();
            $enfant->id_famille=$id_famille; //Famille de l'enfant cahngée
            $enfant->save();
            $msg="L'enfant ".$enfant->NomComplet." a été ajouté à la famille ".$famille->IdPAD." de ".$famille->TitulaireNomComplet;
        }
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function removeEnfant($id_famille,$id_enfant)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');

        $msg="";
        $enfant=Allocataire::find($id_enfant);
        $famille=Famille::find($id_famille);
        if($enfant && $famille) {
            $msg="L'enfant ".$enfant->NomComplet." a été enlevé de la famille ".$famille->IdPAD." de ".$famille->TitulaireNomComplet;
            //Suppression dans FamilleEnfant
            $famille_enfant =  FamilleEnfant::where("id_famille","=",$id_famille)->where("id_enfant","=",$id_enfant)->delete();
            //Suppression dans Enfant
            $enfant->id_famille=0; 
            $enfant->save();
        }
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function autocomplete_enfant(FamilleAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();

        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";

        $search    = DB::select($sql);

        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }



    /* ********** */
    /*    MEMBRES */
    /* ********** */
    public function addMembre($id_famille)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');

        $famille=Famille::find($id_famille);
        return View::make('familles.add_membre_pop', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'famille' => $famille
        ]);
    }

    public function storeMembre(Request $request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');

        $msg="";
        $id_famille=$request->id_famille;
        $id_membre=$request->id_membre;
        $membre=Allocataire::find($id_membre);
        $famille=Famille::find($id_famille);
        if($id_membre && $id_famille) {
            $famille_membre =  new FamilleMembre;
            $famille_membre->id_famille=$id_famille;
            $famille_membre->id_membre=$id_membre;
            $famille_membre->save();
            //$membre->id_famille=$id_famille; //Famille de l'membre cahngée !!! NON Il doit avoir sa propre famille
            //$membre->save();
            $msg="L'membre ".$membre->NomComplet." a été ajouté à la famille ".$famille->IdPAD." de ".$famille->TitulaireNomComplet;
        }
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function removeMembre($id_famille,$id_membre)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');

        $msg="";
        $membre=Allocataire::find($id_membre);
        $famille=Famille::find($id_famille);
        if($membre && $famille) {
            $msg="Le membre ".$membre->NomComplet." a été enlevé de la famille ".$famille->IdPAD." de ".$famille->TitulaireNomComplet;
            //Suppression dans FamilleMembre
            $famille_membre =  FamilleMembre::where("id_famille","=",$id_famille)->where("id_membre","=",$id_membre)->delete();
            //Suppression dans Membre
            //$membre->id_famille=null; 
            //$membre->save();
        }
        Session::flash('message', $msg);
        return Redirect::back();
    }

    //Enlève membre sasn statut
    public function removeAutre($id_famille,$id_autre)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');

        $msg="";
        $membre=Allocataire::find($id_autre);
        $famille=Famille::find($id_famille);
        if($membre->id_famille==$id_famille) {
            $msg="Le membre ".$membre->NomComplet." a été enlevé de la famille ".$famille->IdPAD;
            $membre->id_famille=null;
            $membre->save();
        }
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function autocomplete_membre(FamilleAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        /*
        $sql="select id ,CONCAT(TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id) as value ";
        $sql.=" from allocataires ";
        $sql.=" where (nom like '{$param}%') or (nom_naissance like '{$param}%') or (id='{$param}') or (CONCAT(nom,' ',prenom) like '{$param}%') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";
        */
        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";

        $search    = DB::select($sql);

        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }
}