<?php namespace App\Http\Controllers;

use View;
use Illuminate\Support\Facades\Auth;
use App\Models\MyApp;
use App\Models\Indicateurs;

class HomeController extends Controller
{

    private $menu_home='';
    private $menu='';
    private $submenu='';
    public $role_name="";

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index($type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $dashboard_title="";$menu_home="";
        if(isset(MyApp::TYPES_AIDES[strtoupper($type)])) {
            $menu_home=$type;
            $dashboard_title = MyApp::TYPES_AIDES[strtoupper($type)];
        } else {
            $dashboard_title = $type;
            $menu_home=$type;
        }

        $t_indicateurs=Indicateurs::getIndicateurs($type);
        $types_aides=MyApp::TYPES_AIDES_COURT;
        return view::make('home',[
            "user"=>$user,'menu_home' => $this->menu_home,'menu' => $this->menu,'submenu' => $this->submenu,
            "type" => $type,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,"types_aides" => $types_aides,
            "t_indicateurs" => $t_indicateurs
        ]);
    }


}
