<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Role2;
use App\Models\Permission2;
use App\Models\PermissionGroupe;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\PermissionRequest;


class PermissionsController extends Controller {

    private $menu='acces';
    private $submenu='permissions';
    private $menu_home='acces';


    public function __construct()
    {
        //$this->beforeFilter('auth');
    }


    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $permissions = Permission2::where('id', '<>', 'null')->orderBy('name')->get();
        return View::make('acces.permissions.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'permissions' => $permissions
        ]);
    }


    public function create($mode="create",$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $permission ="";
        if($id){
            $permission = Permission2::find($id);
        }
        $liste_groupes = PermissionGroupe::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        return View::make('acces.permissions.'.$mode,[
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'permission' => $permission,'liste_groupes' => $liste_groupes
        ]);
    }


    public function store(PermissionRequest $request)
    {
        $permission = $this->setData($request);
        return Redirect::to('/permissions');
    }


    public function edit($id)
    {
        return $this->create("edit",$id);
    }


    public function update($id,PermissionRequest $request)
    {
        $permission = $this->setData($request,$id);
        return Redirect::to('/permissions');
    }

    public function show($id)
    {
        return $this->create("show",$id);
    }


    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id) $permission = Permission2::find($id);
        else $permission = new Permission2;
        //Groupe ou new groupe
        if(isset($request->new_groupe) && $request->new_groupe && !$request->id_groupe) {
            $permissions_groupes  = new PermissionGroupe;
            $permissions_groupes->nom=$request->new_groupe;
            $permissions_groupes->save();
            $permission->id_groupe= $permissions_groupes->id;
        } else $permission->id_groupe= $request->id_groupe;

        $permission->name = $request->name;
        $permission->display_name = $request->display_name;
        $permission->save();

        return $permission;
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $permission = Permission2::find($id);
        if(!$permission->IsSupprimable) {
            $msg="Suppression interdite";
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }
        Permission2::destroy($id);
        Session::flash('message', "Suppression effectuée");
        return Redirect::to('/permissions');
    }



}



