<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
use DB;
 
class VersementsController extends Controller {
    private $menu_home="versements";
    private $menu='versements_ter';
    private $submenu='versements_csr';
    

    public function index($type_aide="",$num_imp="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_VISU")) return redirect('home');

        $this->submenu=strtolower('versements_'.$type_aide);
        $title=MyApp::TYPES_AIDES[$type_aide];

        if($num_imp=="") $num_imp=Versement::where('type','=',$type_aide)->max('num_imp');
        $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)->orderBy('date','ASC')->get();
        $liste_num_imp=[];$date_versement="";
        $versements_all=Versement::select("num_imp","date")->distinct()->where('type','=',$type_aide)->orderBy('date','ASC')->get();
        foreach($versements_all as $versement) {
            $liste_num_imp[$versement->num_imp]=str_pad( $versement->num_imp, 4, "0", STR_PAD_LEFT)." (".$versement->date.")";
            $date_versement=$versement->date;
        }
        $deletable=($date_versement && (substr($date_versement,0,7)==date('Y-m')))?true:false;

        return View::make('versements.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type_aide' => $type_aide,
            'num_imp' => $num_imp,'liste_num_imp' => $liste_num_imp,
            'versements' => $versements,'deletable' => $deletable,
        ]);
    }
    //Aide à l'enfant
    public function index_aae($num_imp=""){return $this->index("AAE",$num_imp);}

    //Aide à l'enfant
    public function index_pan($num_imp=""){return $this->index("PAN",$num_imp);}

    //Aide à l'enfant
    public function index_csr($num_imp=""){return $this->index("CSR",$num_imp);}

    //Filet Social
    public function index_fso($num_imp=""){return $this->index("FSO",$num_imp);}


    public function delete_aae($num_imp="") { return $this->delete("AAE",$num_imp);}
    public function delete_pan($num_imp="") { return $this->delete("PAN",$num_imp);}
    public function delete_csr($num_imp="") { return $this->delete("CSR",$num_imp);}
    public function delete_fso($num_imp="") { return $this->delete("FSO",$num_imp);}
    
    public function delete($type_aide,$num_imp)
    {
        $type_aide=strtoupper($type_aide);
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_SUP")) return redirect('home');
        $versements=Versement::where('type','=',$type_aide)
            ->where('num_imp','=',$num_imp)->delete();

        $msg="Le Versement de ".MyApp::PREFIXE_AIDES[$type_aide].MyApp::TYPES_AIDES[$type_aide]." a été supprimé";
        Session::flash('message', $msg);
        return Redirect::to('versements_'.strtolower($type_aide));

    }
    
}