<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\VersementEnfant;
use App\Models\AllocataireRessource;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
use DB;
 
class VersementsPrepaController extends Controller {
    private $menu_home="aides";
    private $menu='aae';
    private $submenu='versements';
    
    //Aide à l'enfant
    public function index_aae(){return $this->index("AAE");}
    //Prime à la naissance
    public function index_pan(){return $this->index("PAN");}
    //Contribution Sociale de Retraite
    public function index_csr(){return $this->index("CSR");}
    //Filet Social
    public function index_fso(){return $this->index("FSO");}

    public function index($type_aide="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_VISU")) return redirect('home');

        $this->menu=strtolower($type_aide);
        $this->submenu="versements_".strtolower($type_aide);
        $title=MyApp::TYPES_AIDES[$type_aide];

        $versements_prepas=VersementPrepa::where('type','=',$type_aide)->get();
        return View::make('versements.prepa.index_prepa', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type_aide' => $type_aide,
            'versements_prepas' => $versements_prepas,
        ]);
    }



    /* *********************** */
    /* Preparation - Validation */
    /* *********************** */
    public function validation_prepa_csr(){return $this->validation_prepa("CSR");}
    public function validation_prepa_aae(){return $this->validation_prepa("AAE");}
    public function validation_prepa_pan(){return $this->validation_prepa("PAN");}
    public function validation_prepa_fso(){return $this->validation_prepa("FSO");}

    public function validation_prepa($type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_PRP")) return redirect('home');

        $this->menu=strtolower($type_aide);
        $this->submenu="versements_".strtolower($type_aide);
        //Si Prime à la naissance on positionne l'aide sur les allocataires avec enfants éligibles
        if($type_aide=="PAN") $this->setEligibles2PAN();

        $allocataires = Allocataire::where('statut_dossier','=','ACT')->where('types_aides','like','%'.$type_aide.'%')->orderBy('nom')->orderBy('prenom')->get();
        foreach(MyApp::ILES as $key=>$ile) {
            $t_stat[$key]=["nb"=>0,"montant"=>0,"montant_rappel"=>0,"total"=>0];
            $t_stat_total=["nb"=>0,"total_montant"=>0,"total_montant_rappel"=>0,"total"=>0];
        }
        $total_versements=0;$montant_versements=0;$montant_versements_r=0;$nb_versements=0;$nb_versements_nd=0;
        foreach($allocataires as $allocataire) {
            if($allocataire->getDroitsOuverture($type_aide)=="OUV") {
                $ile=$allocataire->Ile;
                if(($ile!="W")&&($ile!="F")) $ile="A";
                $t_stat[$ile]["nb"]++;
                if($type_aide=="AAE") { //Si Aide à l'enfant on calcul l'aide
                    $montant_soc=MyApp::getMontantAAE($allocataire->NbEnfantsAAE);
                    $t_stat[$ile]["montant"]+=$montant_soc;
                    $t_stat[$ile]["montant_rappel"]+=$allocataire->rappel_aae;
                    $t_stat[$ile]["total"]+=$allocataire->rappel_aae+$montant_soc;
                }
                if($type_aide=="PAN") { //Si Aide à l'enfant on calcul l'aide
                    $montant_pan=$allocataire->CalculPAN;
                    $t_stat[$ile]["montant"]+=$montant_pan;
                    $t_stat[$ile]["montant_rappel"]+=$allocataire->rappel_pan;
                    $t_stat[$ile]["total"]+=$allocataire->rappel_pan+$montant_pan;
                    
                }
                if($type_aide=="CSR") { //CSR
                    $t_stat[$ile]["montant"]+=$allocataire->montant_csr;
                    $t_stat[$ile]["montant_rappel"]+=$allocataire->rappel_csr;
                    $t_stat[$ile]["total"]+=$allocataire->rappel_csr+$allocataire->montant_csr;
                }
                if($type_aide=="FSO") { //Filet Social
                    $montant_fso=$allocataire->CalculMontantFSO;
                    $t_stat[$ile]["montant"]+=$montant_fso;
                    $t_stat[$ile]["montant_rappel"]+=$allocataire->rappel_fso;
                    $t_stat[$ile]["total"]+=$allocataire->rappel_fso+$montant_fso;
                }

                
                if(!$allocataire->mode_versement) $nb_versements_nd++;
                $nb_versements++;
            }
        }
        return View::make('versements.prepa.valide_prepa_confirm', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type_aide' => $type_aide,
            'nb_versements' => $nb_versements,'nb_versements_nd' => $nb_versements_nd,
            't_stat' => $t_stat,'t_stat_total' => $t_stat_total,
        ]);
    }

    //Aide à l'enfant
    public function generation_aae(){return $this->generation("AAE");}
    //Contribution Sociale de Retraite
    public function generation_csr(){return $this->generation("CSR");}
    //Prime à la naissance
    public function generation_pan(){return $this->generation("PAN");}
    //Filet Social
    public function generation_fso(){return $this->generation("FSO");}

    public function generation($type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_PRP")) return redirect('home');
 
        $this->menu=strtolower($type_aide);
        $this->submenu="versements_".strtolower($type_aide);
        $allocataires = Allocataire::where('statut_dossier','=','ACT')->where('types_aides','like','%'.$type_aide.'%')->orderBy('nom')->orderBy('prenom')->get();
        $versements_prepas=VersementPrepa::where('type','=',$type_aide)->delete(); //SUpprime si existe
        $nb=0;
        foreach($allocataires as $allocataire) {
            //controel ouverture
            if($allocataire->getDroitsOuverture($type_aide)=="OUV") {
                $versement_prepa=$this->addDataVersementPrepa($allocataire,$type_aide);
                $nb++;
            }
        }
        $msg="Génération de ".$nb." lignes de versements pour  l'aide : ". MyApp::TYPES_AIDES[$type_aide];
        Session::flash('message', $msg);
        return Redirect::to("versements_prepa_".strtolower($type_aide));
    }


    /* ************************************* */
    /* Génération Définitive des versements  */
    /* ************************************* */
    //Aide à l'enfant
    public function confirm_generation_def_aae(){return $this->confirm_generation_def("AAE");}
    //Contribution Sociale de Retraite
    public function confirm_generation_def_csr(){return $this->confirm_generation_def("CSR");}
    //Prime à la naissance
    public function confirm_generation_def_pan(){return $this->confirm_generation_def("PAN");}
    //Filet Social
    public function confirm_generation_def_fso(){return $this->confirm_generation_def("FSO");}

    public function confirm_generation_def($type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_VAL")) return redirect('home');

        $this->menu=strtolower($type_aide);
        $this->submenu="versements_".strtolower($type_aide);
        $title="Génération définitive du versement de la ".MyApp::TYPES_AIDES[$type_aide];
        $date_A=date('Y-m');
        $nom_mois=MyApp::MOIS_NUM_TEXTE_LONG[date('m')];
        
        $num_imp=Versement::where('type','like','%'.$type_aide.'%')->max('num_imp');
        $num_imp+=1;
        
        //vérification compte OK
        $versements_prepas=VersementPrepa::where('type','=',$type_aide)->get();
        $error_compte=0;$t_anomalies=[];
        //Vérifie compte pour els virements
        foreach($versements_prepas as $versement_prepa) {
            if($versement_prepa->mode_versement=="VIR") {
                $error=$versement_prepa->getCompteError(",");
                if($error) {
                    $error_compte++;
                    $t_anomalies[]=["nom"=>$versement_prepa->AllocataireNomComplet,"error"=>$versement_prepa->getCompteError(",")];
                }
            }
        }
        $nb_versements=$versements_prepas->count();
       
        $errors_before=array();
        if($error_compte>0)
            $errors_before[]="<b>Impossible de faire la génération</b> : ".$error_compte." compte".
                (($error_compte==1)?"":"s")." bancaire".(($error_compte==1)?" est":"s sont")." en anomalie !";


        //vérification si pas double versement dans le mois
        $nb_existe=Versement::where('type','=',$type_aide)->where('date','like',$date_A."%")->count();

        if( (count($errors_before)>0) || ($nb_existe>0) )
            return View::make('versements.prepa.generation_error', [
                    'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                    'type_aide' => $type_aide,'title' => $title,"nom_mois"=>$nom_mois,
                    'errors_before'=>$errors_before,'t_anomalies'=>$t_anomalies,
                    'nb_versements'=>$nb_versements,'nb_existe'=>$nb_existe
                ]);

        return View::make('versements.prepa.generation_definitive', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type_aide' => $type_aide,
            'num_imp' => $num_imp,
            'title' => $title,
            'errors_before'=>$errors_before,
            'nb_versements'=>$nb_versements,
            'nb_existe'=>$nb_existe
        ]);
    }

    //Aide à l'enfant
    public function generation_def_aae(Request $request){return $this->generation_def($request,"AAE");}
    //Contribution Sociale de Retraite
    public function generation_def_csr(Request $request){return $this->generation_def($request,"CSR");}
    //Prime à la naissance
    public function generation_def_pan(Request $request){return $this->generation_def($request,"PAN");}
    //Filet Social
    public function generation_def_fso(Request $request){return $this->generation_def($request,"FSO");}

    public function generation_def(Request $request,$type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_VAL")) return redirect('home');

        $this->menu=strtolower($type_aide);
        $this->submenu="versements_".strtolower($type_aide);
        $title="Versement de la ".MyApp::TYPES_AIDES[$type_aide];

        $num_imp=intVal($request->num_imp);
        $num_def=str_pad($num_imp, 4, "0", STR_PAD_LEFT);
        $errors=array();
        $nb_versement=0;
        $versements_prepa=VersementPrepa::where('type','=',$type_aide)->orderby('id','ASC')->get();
        $nb_versements_prepa=count($versements_prepa);
        
        if($nb_versements_prepa>0) {
            DB::table("versements")->where('type','=',$type_aide)->where('num_imp','=',$num_imp)->delete();
            //Ajout dans Versement
            foreach($versements_prepa as $versement) {
                $versement = $this->addDataVersement($versement,$type_aide,$num_imp);
                if($type_aide=="AAE") {
                    $res=$this->addDataVersementEnfants($versement);
                    //$allocataire_ressource=$this->addRessource($versement,$type_aide); //Ajoute ressource si besoin
                }
                if($type_aide=="PAN") { //Enregistrement de l'information versemnts sur la fiche Allocataire/Enfant
                    $liste_id_enfant= $versement->id_enfants;
                    $t_enfants=explode(",",$liste_id_enfant);
                    foreach($t_enfants as $key=>$id)  {
                        $enfant=Allocataire::find($id);
                        $enfant->id_versement_pan=$versement->id;
                        $enfant->save();
                    }
                    //Supprime cette aide de la fiche Allocataire
                    $allocataire=Allocataire::find($versement->id_allocataire);
                    $allocataire->types_aides=str_replace(",PAN","",$allocataire->types_aides);
                    $allocataire->types_aides=str_replace("PAN,","",$allocataire->types_aides);
                    $allocataire->types_aides=str_replace("PAN","",$allocataire->types_aides);
                    $allocataire->save();
                }
            }
            $nb_versement=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)->count();
            $copyOK=($nb_versement == $nb_versements_prepa);

            //Suppression du brouillard et des observations // MODIF 09/2020
            if($copyOK) {
                //Suppression versement_brouillon
                DB::table("versements_prepa")->where('type','=',$type_aide)->delete();
            } else {
                //Suppression des créations
                DB::table("versements")->where('type','=',$type_aide)->where('num_imp','=',$num_imp)->delete();
            }
            if(!$copyOK) $errors[]="La copie dans l'historique annuel n'a pas été réalisée (".$nb_versement.'/'.$nb_versements_prepa.")";
        } else {
            $errors[]="Aucune information à transférer, le fichier brouillard de versement est vide";

        }

        return View::make('versements.prepa.generation_definitive', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type_aide' => $type_aide,
            'num_imp' => $num_imp,'num_def' => $num_def,
            'nb_versement' => $nb_versement,
            'errors'  => $errors,
            'title' => $title
        ]);

    }

    

    /* *********************************** */
    /* Ajout dans la table ressources */
    /* *********************************** */
    public function addRessource($versement,$type_aide) {
        if($type_aide="AAE") $type_ressource="RES_APA";
        if(!$type_ressource) return "";
        //Si AAE on vérifie que dans les ressource 
        $allocataire_ressource=AllocataireRessource::where('id_allocataire','=',$versement->id_allocataire)
                ->where("type_ressource","=",$type_ressource)
                ->where("date_fin",">=",date("y-m-d"))
                ->first();
        if(!$allocataire_ressource) {
            $allocataire_ressource=new AllocataireRessource;
            $allocataire_ressource->id_allocataire=$versement->id_allocataire; 
            $allocataire_ressource->type_ressource=$type_ressource;
            $allocataire_ressource->montant=$versement->montant;
            $allocataire_ressource->source="SITAS";
            $allocataire_ressource->observations="Création auto/versement N°".$versement->num_imp." le ".$versement->date;
            $allocataire_ressource->date_fin=null;
            $allocataire_ressource->save();
        }
        return $allocataire_ressource;
    }



    /* *********************************** */
    /* Ajout dans la table versement_prepa */
    /* *********************************** */
    public function addDataVersementPrepa($allocataire,$type_aide) {
        $versement_prepa=new VersementPrepa;
        $versement_prepa->id_allocataire=$allocataire->id;
        $versement_prepa->id_banque=$allocataire->BanqueId;
        $versement_prepa->destinataire_nom=$allocataire->nom_naissance;
        $versement_prepa->destinataire_prenom=$allocataire->prenom;
        $versement_prepa->num_imp=null;
        $versement_prepa->type=$type_aide;
        $versement_prepa->date=date('Y-m-d');
        $versement_prepa->ile=$allocataire->Ile;
        $versement_prepa->district=$allocataire->DistrictNom;
        $versement_prepa->village=$allocataire->VillageNom;
        $versement_prepa->nb_enf=$allocataire->NbEnfantsAAE;
        $versement_prepa->nbpers_foyer=$allocataire->FamilleNbPersonnes;
        $versement_prepa->qf=$allocataire->QF;
        $versement_prepa->titulaire=$allocataire->NomTitulaireCompte;
        if($allocataire->mode_versement=="VIR") {
            $compte=str_replace(" ","",$allocataire->Compte);
        } else $compte=null;
        $versement_prepa->compte=$compte;
        $versement_prepa->mode_versement=$allocataire->mode_versement;
        
        if($allocataire->mode_versement=="NUM") { //GESTION DES PROCURATIONS si numéraire
            //if($allocataire->id==324) dd($allocataire->ProcurationDateFinUS.">=".date("Y-m-d"));
            if($allocataire->procuration_nom && 
                ( ($allocataire->ProcurationDateFinUS>=date("Y-m-d")|| $allocataire->ProcurationDateFinUS==null) && ($allocataire->ProcurationDateDebutUS<=date("Y-m-d")))
                ) {
                $versement_prepa->procuration_nom = $allocataire->procuration_nom; 
                $versement_prepa->procuration_prenom = $allocataire->procuration_prenom; 
                $versement_prepa->procuration_date_naissance = $allocataire->ProcurationDateNaissanceUS; 
                $versement_prepa->procuration_date_debut = $allocataire->ProcurationDateDebutUS; 
                $versement_prepa->procuration_date_fin = $allocataire->ProcurationDateFinUS; 
                $versement_prepa->procuration_motif = $allocataire->procuration_motif; 
            }
        }

        if($type_aide=="AAE") { //Si Aide à l'enfant on calcul l'aide
            $versement_prepa->montant=MyApp::getMontantAAE($allocataire->NbEnfantsAAE);
            $versement_prepa->montant_r=$allocataire->rappel_aae;
            $versement_prepa->observations=$allocataire->obs_aae;
        }
        if($type_aide=="PAN") { //Si Prime à la naissance on calcul l'aide
            $versement_prepa->montant=$allocataire->CalculPAN;
            $versement_prepa->montant_r=$allocataire->rappel_pan;
            $versement_prepa->observations=$allocataire->obs_pan;
            $versement_prepa->id_enfants=$allocataire->getIdEnfantsEligiblePAN();
        }
        if($type_aide=="CSR") { //CSR
            $versement_prepa->montant=$allocataire->montant_csr;
            $versement_prepa->montant_r=$allocataire->rappel_csr;
            $versement_prepa->observations=$allocataire->obs_csr;
            $id_conjoint=$allocataire->FamilleIdConjoint;
            if($id_conjoint) {
                $versement_prepa->id_conjoint=$id_conjoint;
                $versement_prepa->retraite_conjoint=($allocataire->RetraiteConjoint)?$allocataire->RetraiteConjoint:0;
            }
        }
        if($type_aide=="FSO") { //Filet SOcial
            $versement_prepa->montant=$allocataire->CalculMontantFSO;
            $versement_prepa->montant_r=$allocataire->rappel_fso;
            $versement_prepa->observations=$allocataire->obs_fso;
        }

        $versement_prepa->save();
        return $versement_prepa;
    }

    /* *********************************** */
    /* Ajout dans la table versement */
    /* *********************************** */
    public function addDataVersement($versement_prepa,$type_aide,$num_imp) {
        $versement=new Versement;
        $versement->id_allocataire=$versement_prepa->id_allocataire;
        $versement->id_banque=$versement_prepa->id_banque;
        $versement->destinataire_nom=$versement_prepa->destinataire_nom;
        $versement->destinataire_prenom=$versement_prepa->destinataire_prenom;
        $versement->num_imp=$num_imp;
        $versement->type=$versement_prepa->type;
        $versement->date=date('Y-m-d');
        $versement->ile=$versement_prepa->ile;
        $versement->district=$versement_prepa->district;
        $versement->village=$versement_prepa->village;
        $versement->nb_enf=$versement_prepa->nb_enf;
        $versement->nbpers_foyer=$versement_prepa->nbpers_foyer;
        $versement->qf=$versement_prepa->qf;
        $versement->titulaire=$versement_prepa->titulaire;
        $versement->compte=$versement_prepa->compte;
        $versement->mode_versement=$versement_prepa->mode_versement;
        $versement->procuration_nom = $versement_prepa->procuration_nom; 
        $versement->procuration_prenom = $versement_prepa->procuration_prenom; 
        $versement->procuration_date_naissance = $versement_prepa->DateNaissanceUS; 
        $versement->procuration_date_debut = $versement_prepa->DateDebutUS; 
        $versement->procuration_date_fin = $versement_prepa->DateFinUS; 
        $versement->procuration_motif = $versement_prepa->procuration_motif; 
        $versement->montant=$versement_prepa->montant;
        $versement->montant_r=$versement_prepa->montant_r;
        $versement->observations=$versement_prepa->observations;
        $versement->id_conjoint=$versement_prepa->id_conjoint;
        $versement->retraite_conjoint=$versement_prepa->retraite_conjoint;
        $versement->id_enfants=$versement_prepa->id_enfants;
        $total=$versement_prepa->montant+$versement_prepa->montant_r;
        if($total>0)
        $versement->save();

        return $versement;
    }

    /* ***********************************  */
    /* Ajout dans la table versement ENFANT */
    /* ***********************************  */
    public function addDataVersementEnfants($versement) {
        $versements_enfants=VersementEnfant::where('id_versement','=',$versement->id)->delete();
        $allocataire=Allocataire::find($versement->id_allocataire);
        $enfants=$allocataire->getEnfantsAAE();
        foreach($enfants as $enfant) {
            $versements_enfants=new VersementEnfant;
            $versements_enfants->id_versement=$versement->id;
            $versements_enfants->id_enfant=$enfant->id;
            $versements_enfants->age_enfant=$enfant->Age;
            $versements_enfants->certificat=$enfant->certificat_enfant;
            $versements_enfants->save();
        }
        return true;
    }

    /* ***********************************  */
    /* Positionne le statut d'aide à la naissane sur les allocataires éligibles */
    /* ***********************************  */
    public function setEligibles2PAN() {
        $type_aide="PAN";
        $allocataires=Allocataire::all();
        foreach($allocataires as $allocataire) {
            //Ajout du statut
            if(($allocataire->IsTitulaire)&&($allocataire->EligiblePAN)) {
                if(!$allocataire->hasAide("PAN")) {
                    $allocataire->types_aides.=((!$allocataire->types_aides)?'':',').$type_aide;
                    $allocataire->save();
                }
            } else { //On supprime le statut
                $lst="";
                $t_aides=explode(",",$allocataire->types_aides);
                //if($allocataire->id==1713) dd($t_aides);
                foreach($t_aides as $aide) 
                    if($aide!=$type_aide) 
                        $lst=(($lst=="")?'':",").$aide;
                $allocataire->types_aides=$lst;
                $allocataire->save();
            }          
        }
        return true;
    }

    
}