<?php namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AllocataireRequest extends FormRequest {
    public function rules() {
        return [
            'id_cpswf' => '',
            'id_employeur' => '',
            'type' => 'max:3',
            'nom' => 'max:80',
            'nom_naissance' => 'required|max:80',
            'prenom' => 'required|max:80',
            'sexe' => 'required|max:1',
            'date_naissance' => 'required',
            'date_deces' => '',
            'lieunaiss' => 'max:80',
            'adresse' => '',
            'code_postal' => 'max:5',
            'boite_postale ' => 'max:10',
            'ile' => 'max:1',
            'district' => 'max:20',
            'id_village' => 'required',
            'mobile' => 'max:6',
            'tel' => 'max:20',
            'email' => 'max:255',
            'quot_fam' => '',
            'quot_foy' => '',
            'droits_cpswf' => 'max:20',
            'rappel_aae' => 'numeric',
            'obs_aae' => '',
            'montant_csr' => 'numeric',
            'rappel_csr' => 'numeric',
            'obs_csr' => '',
            'obs' => '',
            'certificat_enfant' => '',
            'mode_versement' => 'max:3',
            'procuration_nom' => 'max:80',
            'procuration_prenom' => 'max:80',
            'procuration_date_naissance' => '',
            'procuration_date_debut' => '',
            'procuration_date_fin' => '',
            'procuration_motif' => '',
            'statut_dossier' => 'required|max:6',
            'statut_conjugal' => 'max:6',
            'statut' => '',
            'verrou' => '',
        ];
    }

     public function attributes() {
        return [
            'id_cpswf' => 'Identifiant CPSWF',
            'id_employeur' => 'Employeur',
            'type' => 'Type de bénéficiaire',
            'date_pi' => 'Date de première immatriculation',
            'nom' => 'Nom',
            'nom_naissance' => 'Nom de naissance',
            'prenom' => 'Prénom',
            'sexe' => 'Sexe',
            'date_naissance' => 'Date de naissance',
            'date_deces' => 'Date de décès',
            'lieunaiss' => 'Lieu ed naissance',
            'adresse' => 'Adresse',
            'code_postal' => 'Code postal',
            'boite_postale ' => 'Boîte postale',
            'ile' => 'Ile',
            'district' => 'District',
            'id_village' => 'Village',
            'mobile' => 'Téléphone mobile',
            'tel' => 'Téléphone',
            'email' => 'Email',
            'quot_fam' => 'Quotien familial',
            'quot_foy' => 'Quotien du foyer',
            'droits_cpswf' => 'Droits',
            'rappel_aae' => "Montant du rappel Aide à l'enfant",
            'obs_aae' => 'Observations AAE',
            'montant_csr' => 'Montant CSR',
            'rappel_csr' => "Montant du rappel CSR",
            'obs_csr' => 'Observations CSR',
            'obs' => 'Observations',
            'certificat_enfant' => 'Certificat enfant',
            'mode_versement' => 'Mode de versement',
            'procuration_nom' => 'Procuration:NOM',
            'procuration_prenom' => 'Procuration:',
            'procuration_date_naissance' => 'Procuration:Date de naissance',
            'procuration_date_debut' => 'Procuration:Date de début',
            'procuration_date_fin' => 'Procuration:Date de fin',
            'procuration_motif' => 'Procuration:Motif',
            'statut_dossier' => 'Statut dossier',
            'statut_conjugal' => 'Statut conjugal',
            'statut' => 'Statut',
            'verrou' => 'Verrou',
        ];
    }



    public function authorize() {
        return true;
    }
}












