<?php namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BanqueRequest extends FormRequest {
    public function rules() {
        return [
            'id' => '',
            'nom' => 'required|max:50',
            'adresse' => '',
            'cp' => 'max:5',
            'ville' => 'max:50',
            'tel' => 'max:20',
            'email' => 'max:255',
            'contact' => 'max:255',
            'agence' => 'max:5',
            'bic' => 'max:11',
        ];
    }

     public function attributes() {
        return [
            'id_' => 'Identifiant',
            'nom' => 'Nom',
            'adresse' => 'Adresse',
            'cp' => 'Code postal',
            'ville' => 'Ville',
            'tel' => 'Téléphone',
            'email' => 'Email',
            'contact' => 'Contact',
            'agence' => 'Agence',
            'bic' => 'Bic',
        ];
    }



    public function authorize() {
        return true;
    }
}












