<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Collection;

class Famille extends Model {


	protected $table = 'familles';

    /**************	*/
    /* ID 			*/
    /**************	*/
    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }

	public function getVillageNomCompletAttribute()
    {
		$titulaire=$this->getTitulaire();
		if(!$titulaire) return "";
        return $titulaire->VillageFullName;
    }

    public function getIleAttribute()
    {
		$titulaire=$this->getTitulaire();
		if(!$titulaire) return "";
        return $titulaire->Ile;
    }
    
    
    /**************	*/
    /* Nombre    */
    /**************	*/
	public function getNbPersonnesAttribute()
    {
        $nb=0;
		if($this->id_titulaire) $nb++;
		if($this->id_conjoint) $nb++;
        $nb+=$this->NbEnfantsLess;
        return $nb;
    }

/* 
    public function  getCalculMontantFSO()
    {
        $montant=0;
        //Titulaire
        $titulaire=$this->getTitulaire();
        $montant+=$titulaire->CalculFSO;
        //Conjoint
        $conjoint=$this->getConjoint();
        if($conjoint) $montant+=$conjoint->CalculFSO;
        //Enafants
        $famillesenfants=$this->getEnfantsLess();
        foreach($famillesenfants as $familleenfant) {
            $enfant=Allocataire::find($familleenfant->id_enfant);
            $montant+=$enfant->CalculFSO;
        }
        //Autres  Membres
		$famillemembres=$this->getMembres();
        
		foreach($famillemembres as $famillemembre) {
            $membre=Allocataire::find($famillemembre->id_membre);
            $montant+=$membre->CalculFSO;
		}
        return $montant;
    }

    public function  getMembreAvecFSO($type="1")
    {
        $montant_base_moins=MyApp::getParam("FSO_MONTANT1");
        $montant_base_plus=MyApp::getParam("FSO_MONTANT2");
        if($type=="1") $prime_type=$montant_base_moins;
        else $prime_type=$montant_base_plus;

        $montant=0;$t_id=[];
        //Titulaire
        $titulaire=$this->getTitulaire();
        if($titulaire->CalculFSO==$prime_type) $t_id[]=$titulaire->id;
        //Conjoint
        $conjoint=$this->getConjoint();
        if($conjoint) if($conjoint->CalculFSO==$prime_type) $t_id[]=$conjoint->id;
        //Enfants
        $famillesenfants=$this->getEnfantsLess();
        foreach($famillesenfants as $familleenfant) {
            $enfant=Allocataire::find($familleenfant->id_enfant);
            if($enfant->CalculFSO==$prime_type) $t_id[]=$enfant->id;
        }
        //Autres  Membres
		$famillemembres=$this->getMembres();
		foreach($famillemembres as $famillemembre) {
            $membre=Allocataire::find($famillemembre->id_membre);
            if($membre->CalculFSO==$prime_type) $t_id[]=$membre->id;
		}

        $allocataires_fso=Allocataire::whereIn('id',$t_id)->get();
        return $allocataires_fso;
    }
    */

    /*
	public function getNbPersonnesFoyerAge($age_min=0,$age_max=999,$certifs="")
    {
        $nb=0;
        //Titulaire
        $titulaire=$this->getTitulaire();
        if($titulaire && $titulaire->age>=$age_min && $titulaire->age<$age_max) $nb++;

        //Conjoint
        $conjoint=$this->getConjoint();
        if($conjoint && $conjoint->age>=$age_min && $conjoint->age<$age_max) $nb++;
        
        //Recherche des Membres
		$membres=$this->getMembres();
		foreach($membres as $membre) {
            if($membre->age>=$age_min && $membre->age<$age_max) $nb++;
		}
        
        //Recherche des enfants
		$famillesenfants=$this->getEnfantsLess();
		foreach($famillesenfants as $familleenfant) {
            $enfant=Allocataire::find($familleenfant->id_enfant);
            if($enfant->id_famille==$this->id) {//Pas de hors foyer
                if($enfant->age>=$age_min && $enfant->age<$age_max) {
                    $certifok=false;
                    if(!$certifs) {$certifok=true;}
                    else {
                        foreach($certifs as $certif) {
                            if($certif==$enfant->certificat_enfant) {$certifok=true;}
                        }
                    }
                    if($certifok) $nb++;
                }
            }
		}
        return $nb;
    }
        */

    /**************	*/
    /* TITULAIRE    */
    /**************	*/
	public function getStatutTitulaireAttribute()
    {
		$titulaire=$this->getTitulaire();
		if(!$titulaire) return "";
        return $titulaire->statut;
    }


    /***************/
    /* RESSOURCES */
    /***************/
    public function getMontantRessourcesAttribute()
    {
        $montant=0;
        //REssource Titulaire
        $titulaire=$this->getTitulaire();
        if($titulaire) $montant+=$titulaire->MontantRessources;

        //REssource Conjoint
        $conjoint=$this->getConjoint();
        if($conjoint) $montant+=$conjoint->MontantRessources;
        //Personnes à charge
        $enfants=$this->getEnfants();
        foreach($enfants as $enfant) $montant+=$enfant->MontantRessources;

        return $montant;
    }

    //Quotien Famillial
    public function getQFAttribute()
    {
        $nbmembres_foyer=$this->NbPersonnes;
        if($nbmembres_foyer==0) return "";
        $ressources=$this->MontantRessources;
        $qf=round($ressources/$nbmembres_foyer,0);;
        return $qf;
    }
    /**************	*/
    /* AIDES    */
    /**************	*/
    public function getAides($card=true,$sep="<br/>")
    {
		$titulaire=$this->getTitulaire();
		if(!$titulaire) return "";
        return $titulaire->getInfoDetailAides($card,$sep);
    }

    public function hasAide($type_aide)
    {
		$titulaire=$this->getTitulaire();
		if(!$titulaire) return "";
        return $titulaire->hasAide($type_aide);
    }

    /**************	*/
    /* CONJOINTS 	*/
    /**************	*/
    public function getParentsListe($sep="<br/>")
    {
		$txt="";
		$titulaire=Allocataire::find($this->id_titulaire );
		$conjoint=Allocataire::find($this->id_conjoint );
		if($titulaire) $txt.="<b>".$titulaire->NomComplet."</b>";
		if($conjoint) $txt.=(($txt)?$sep:"").$conjoint->NomComplet;

        return $txt;
    }

	public function getTitulaire()
    {
		$titulaire=Allocataire::find($this->id_titulaire );
		if(!$titulaire) return "";
        return $titulaire;
    }



	public function getConjoint()
    {
		$conjoint=Allocataire::find($this->id_conjoint );
		if(!$conjoint) return "";
        return $conjoint;
    }

    /**************	*/
    /* ENFANTS 		*/
    /**************	*/
    public function getEnfantsListe($sep="<br/>")
    {
		$txt="";
		$enfants=FamilleEnfant::where('id_famille','=',$this->id )->get();
		foreach($enfants as $enfant) {
            $certif=$enfant->Certificat;
            if(in_array($certif,MyApp::getCertificatsAAE()))  $certif="<span class='right badge badge-".MyApp::COLOR_AIDES["AAE"]."'>".$certif."</span>";
            else $certif="<span class='right badge badge-secondary'>".$certif."</span>";

			$txt.=(($txt)?$sep:"").$enfant->NomComplet."&nbsp;".$enfant->Age."a".($certif?"&nbsp;".$certif:")");
            $lib_aide=$enfant->getInfoDetailAides();
            if($lib_aide) $txt.=" ".$enfant->getInfoDetailAides();
		}

        return $txt;
    }

    public function getEnfantsLessListe($sep="<br/>")
    {
		$txt="";
		$enfants=$this->getEnfantsLESS();
		foreach($enfants as $enfant) {
            $certif=$enfant->Certificat;
            if(in_array($certif,MyApp::getCertificatsAAE()))  $certif="<span class='right badge badge-".MyApp::COLOR_AIDES["AAE"]."'>".$certif."</span>";
            else $certif="<span class='right badge badge-secondary'>".$certif."</span>";

			$txt.=(($txt)?$sep:"").$enfant->NomComplet."&nbsp;".$enfant->Age."a".($certif?"&nbsp;".$certif:")");
            $lib_aide=$enfant->getInfoDetailAides();
            if($lib_aide) $txt.=" ".$enfant->getInfoDetailAides();
		}

        return $txt;
    }

    /*
    public function getEnfants2()
    {
        $famillesenfants=FamilleEnfant::where('id_famille','=',$this->id )->get();
        $t_id_enfants=[];
        foreach($famillesenfants as $familleenfant) {
            $enfant=Allocataire::find($familleenfant->id_enfant);
            echo $familleenfant->id_enfant." , ".$enfant->id_famille."==".$this->id."<br/>";
            if($enfant->id_famille==$this->id) {
                $t_id_enfants[]=$enfant->id;
            }
        }
        dd($t_id_enfants);
        $enfants=Allocataire::whereIn('id',$t_id_enfants)->orderby('allocataires.date_naissance','DESC')->get();

        return $enfants;
    }
        */
    
    public function getEnfants()
    {
		$enfants=FamilleEnfant::join('allocataires','allocataires.id','=','familles_enfants.id_enfant')
            ->where('familles_enfants.id_famille','=',$this->id )->orderby('allocataires.date_naissance','DESC')->get('familles_enfants.*');
        if(!$enfants) return null;
        return $enfants;
    }


    public function getEnfantsLESS($age=21)
    {
		$enfants_temp=$this->getEnfants();
        $enfants=collect();
        foreach($enfants_temp as $enfant) 
            if( $enfant->Age<=21) $enfants->push($enfant);//$enfants[]=$enfant;
        return $enfants;
    }

    public function getEnfantsSUP($age=21)
    {
		$enfants_temp=$this->getEnfants();
        $enfants=collect();
        foreach($enfants_temp as $enfant) 
            if( $enfant->Age>21) $enfants->push($enfant);//$enfants[]=$enfant;
        return $enfants;
    }

    /**
     * Nombre d'enfants 
     */
    public function getNbEnfantsAttribute()
    {
        $nb=FamilleEnfant::where('id_famille','=',$this->id )->count();
        return $nb;
    }

    /**
     * Nombre d'enfants -21
     */
    public function getNbEnfantsLESSAttribute()
    {
        $nb=$this->getEnfantsLESS()->count();
        return $nb;
    }

    /**
     * Nombre d'enfants pour Aide Sociale
     */
    public function getNbEnfantsAAEAttribute()
    {
        $certif_aae=MyApp::getCertificatsAAE();
        $nb=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id )
            ->whereIn('certificat_enfant',$certif_aae)
            ->count();
        return $nb;
    }

    /**************	*/
    /* MEMBRES 		*/
    /**************	*/
    public function getMembresListe($sep="<br/>")
    {
		$txt="";
		$membres=$this->getMembres();
		foreach($membres as $membre) {
			$txt.=(($txt)?$sep:"").$membre->NomComplet."&nbsp;".$membre->Age."a";
            $lib_aide=$membre->getInfoDetailAides();
            if($lib_aide) $txt.=" ".$membre->getInfoDetailAides();
		}

        return $txt;
    }

    public function getMembres()
    {
		$membres=FamilleMembre::where('id_famille','=',$this->id )->get();
        return $membres;
    }


    public function getcanDeleteAttribute()
    {
        if($this->id_conjoint) return false; 
		$nb=FamilleEnfant::where('id_famille','=',$this->id )->count();
        if($nb==0) $nb=FamilleMembre::where('id_famille','=',$this->id )->count();
        //if($nb==0) $nb=FamilleAidant::where('id_famille','=',$this->id )->count();
        if($nb>0) return false;

        return true;
    }

    /********************************	*/
    /* AUTRES MEMBRES SANS STATUTS		*/
    /********************************	*/
    public function getAutres()
    {
        //recherche de tous les membre 
        //Pas membre
        $t_id_membres=FamilleMembre::where('id_famille','=',$this->id )->pluck('id_membre')->toArray();
        //Pas membre
        $t_id_enfants=FamilleEnfant::where('id_famille','=',$this->id )->pluck('id_enfant')->toArray();
        //Cumul des codes
        
        $t_id_remove=array_merge($t_id_membres,$t_id_enfants);
        if($this->id_titulaire) $t_id_remove[]=$this->id_titulaire;
        if($this->id_conjoint) $t_id_remove[]=$this->id_conjoint;

		$membres_restants=Allocataire::where('id_famille','=',$this->id )->whereNotIn("id",$t_id_remove)->get();
        if(!$membres_restants) return "";
        return $membres_restants;
    }

    public function getNbAutresMembresAttribute()
    {
        $autres=$this->getAutres();
        if(!$autres) return 0;
        return $autres->count();
    }

    public function getAutresMembresListe($sep=",")
    {
        $autres=$this->getAutres();
		$txt="";
		foreach($autres as $autre) {
			$txt.=(($txt)?$sep:"").$autre->NomComplet."&nbsp;".$autre->Age."a";
            $lib_aide=$autre->getInfoDetailAides();
            if($lib_aide) $txt.=" ".$autre->getInfoDetailAides();
		}

        return $txt;
    }
    

}
