<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;


class Indicateurs  {


	//getNB Etablissements
	static public function getIndicateurs($type="") {
		$t_indicateurs=[];
		
       	switch ($type) {
            case "":
            case "parametres":
				$budget_dep=0;				
				$t_indicateurs["budget_all"]=0;
				$t_indicateurs["budget_rst_all"]=0;
				$t_indicateurs["budget_dist_all"]=0;
				$t_indicateurs["nb_benef_all"]=0;
				
				$t_indicateurs["nb_allocataires"]=Allocataire::count();
                $t_indicateurs["nb_benef"]=Indicateurs::getNbBenef();
				$t_indicateurs["nb_enfant"]=Indicateurs::getNbEnfant();
				$t_indicateurs["nb_famille"]=Famille::count();
				$t_indicateurs["nb_versements"]=Indicateurs::getNbVersements();
				
				foreach(MyApp::TYPES_AIDES as $code=>$nom) {
					$budget_dep=MyApp::getBudget($code);
					$t_solde[$code]=MyApp::getSoldeBudget($code);
					$t_solde_prc[$code]=MyApp::getSoldePrcBudget($code);
					$t_indicateurs["nb_benef_".strtolower($code)]=Indicateurs::getNbBenef($code);
					$t_indicateurs["budget_".strtolower($code)]=number_format($budget_dep,0,","," ");
					$t_indicateurs["budget_rst_".strtolower($code)]=number_format($t_solde[$code],0,","," ");
					$t_indicateurs["budget_dist_".strtolower($code)]=number_format($budget_dep-$t_solde[$code],0,","," ");
					$t_indicateurs["budget_prc_".strtolower($code)]=number_format($t_solde_prc[$code],0,","," ");
					$t_indicateurs["budget_rst_all"]+=intVal($t_solde[$code]);
					$t_indicateurs["budget_all"]+=$budget_dep;
					$t_indicateurs["nb_benef_all"]+=$t_indicateurs["nb_benef_".strtolower($code)];					
				}
				if($t_indicateurs["budget_all"]>0) $prc=round(100*(1-$t_indicateurs["budget_rst_all"]/$t_indicateurs["budget_all"]),0);
				else $prc="-";
				$t_indicateurs["budget_prc_all"]=$prc;
				$t_indicateurs["budget_dist_all"]=number_format($t_indicateurs["budget_all"]-$t_indicateurs["budget_rst_all"],0,","," ");
				$t_indicateurs["budget_rst_all"]=number_format($t_indicateurs["budget_rst_all"],0,","," ");
				$t_indicateurs["budget_all"]=number_format($t_indicateurs["budget_all"],0,","," ");
                break;

				
            case "acces" ;
			case "aides":
                $t_indicateurs["nb_benef"]=Indicateurs::getNbBenef($type);
				foreach(MyApp::TYPES_AIDES as $code=>$nom)
					$t_indicateurs["nb_benef_".strtolower($code)]=Indicateurs::getNbBenef($code);
                $t_indicateurs["nb_utilisateurs"]=Indicateurs::getNbUtilisateurs();
                $t_indicateurs["nb_roles"]=Indicateurs::getNbRoles();
                $t_indicateurs["nb_permissions"]=Indicateurs::getNbPermissions();
                break;

			case "importations":
				$t_indicateurs["nb_benef"]=Indicateurs::getNbBenef($type);
                $t_indicateurs["nb_utilisateurs"]=Indicateurs::getNbUtilisateurs();
                $t_indicateurs["nb_roles"]=Indicateurs::getNbRoles();
                $t_indicateurs["nb_permissions"]=Indicateurs::getNbPermissions();
                break;

			case "analyses":
				$t_indicateurs["nb_benef"]=Indicateurs::getNbBenef($type);
				foreach(MyApp::TYPES_AIDES as $code=>$nom)
					$t_indicateurs["nb_benef_".strtolower($code)]=Indicateurs::getNbBenef($code);
				break;
    	}
        return $t_indicateurs;
      }
	  

	static public function getNbBenef($type="") {
		$nb=0;
		if(!$type) 
			$nb=Allocataire::whereNotNull('types_aides')->where("types_aides","<>","")->count();
		else $nb=Allocataire::where('types_aides','like','%'.$type.'%')->count();

		return $nb;
	}  

	static public function getNbEnfant() {
		$nb=FamilleEnfant::count();

		return $nb;
	}  
	

	
	static public function getNbFamillesBenef() {
		$nb=Famille::count();
		return $nb;
	} 

	static public function getNbVersements() {
		$nb=Versement::count();
		return $nb;
	} 

	//Nombre d'utilisateurs
	static public function getNbUtilisateurs() {
		$nb=User::where('actif','=', "1")->count();
		return $nb;
	}

	//Nombre de rôles
	static public function getNbRoles() {
		$nb=Role2::where('id','<>', "")->count();
		return $nb;
	}

	//Nombre de rôles
	static public function getNbPermissions() {
		$nb=Permission2::where('id','<>', "")->count();
		return $nb;
	}


}